// file: discriminator.h

#ifndef __DISCRIMINATOR_H
#define __DISCRIMINATOR_H

#include "Region.h"

#include <vector>

std::vector<Region> * discriminator(
	std::vector<float>& input,       // vector of floats, the discriminator acts on
    float thr = 5.,             // threshold
    bool clean = true,          // choose here, if the discriminator should already discard Regions, which are assumend to sit on the predessesors falling edge
    int fallingEdge = 100,      // number of slices, after the maximum, which should be discarded...  
    bool debug = false
);

int cleanRegionsOnFallingEdge (
	std::vector<Region> &dest,
	std::vector<Region> &src,
    int fallingEdgeLen = 100,
    bool debug = false);
	

#endif
