#include <TROOT.h>
#include <TCanvas.h>
#include <TProfile.h>

#include <stdint.h>
#include <cstdio>

#define HAVE_ZLIB
#include "fits.h"
#include "FOpenDataFile.c"

int plotevent(
	char *title, 
	vector<int16_t> &data, 
	UInt_t data_roi, 
	size_t pixelnr);


int plotraw(const char *name = "../raw/20110916_025.fits", size_t eventnr = 0, size_t pixelnr = 0)
{
	gROOT->SetStyle("Plain");
	
	fits datafile(name);
	if (!datafile)
	{
	cout << "Couldn't properly open the datafile." << endl;
	return 1;
	}
	
//-------------------------------------------
//Get the data
//-------------------------------------------
	vector<int16_t> data;
	vector<int16_t> data_offset;
	unsigned int data_num;
	size_t data_n;
	UInt_t data_px;
	UInt_t data_roi;
	FOpenDataFile(datafile, data, data_offset, data_num, data_n, data_roi, data_px);
	
	
//-------------------------------------------
//Create the title
//-------------------------------------------
	char title[500];
	std::sprintf(title,"Data: %s, Px %i Ev %i",name,pixelnr,eventnr);
	
//-------------------------------------------
//Get the event
//-------------------------------------------
	cout << "--------------------- Data --------------------" << endl;
	datafile.GetRow(eventnr);
	cout << "Event number: " << data_num << endl;
		
//-------------------------------------------
//Draw the data
//-------------------------------------------
	plotevent(title, data, data_roi, pixelnr);
	return 0;
}



int plotevent(
	char *title, 
	vector<int16_t> &data, 
	UInt_t data_roi, 
	size_t pixelnr)
{
	TCanvas *canv = new TCanvas( "canv", "Mean values of the first event", 100, 10, 700, 500 );
	TProfile *pix = new TProfile("pix", title, 1024, -0.5, 1023.5);

	for (UInt_t k=0; k<data_roi; k++)
	{
		float sample = (data[pixelnr*data_roi+k]);
		pix->Fill(k,sample);
	}
	pix->Draw();
	canv->Modified();
	canv->Update();
	
	return 0;
}
