#include <cstdio>

int FOpenCalibFile(
	const char *drsname,
	std::vector<float> &drs_basemean,
	std::vector<float> &drs_gainmean,
	std::vector<float> &drs_triggeroffsetmean,
	size_t &drs_n)
{
//-------------------------------------------
//Open the file
//-------------------------------------------
	fits drsfile(drsname);
	
	if (!drsfile)
	{
	cout << "Couldn't properly open the drsfile." << endl;
	return 1;
	}
	
//-------------------------------------------
//Print the header
//-------------------------------------------
	cout << "----------------- DRS Calib Header -----------------" << endl;
	drsfile.PrintKeys();
	cout << "---------------- DRS Calib Columns -----------------" << endl;
	drsfile.PrintColumns();
	
//-------------------------------------------
//Get the sizes of the data column
//-------------------------------------------
	drs_n = drsfile.GetN("BaselineMean");
	
//-------------------------------------------
//Set the sizes of the DRS data vectors
//-------------------------------------------
	drs_basemean.resize(drs_n,0);
	drs_gainmean.resize(drs_n,0);
	drs_triggeroffsetmean.resize(drs_n,0);
	
//-------------------------------------------
//Link the data to variables
//-------------------------------------------
	drsfile.SetVecAddress("BaselineMean", drs_basemean);
	drsfile.SetVecAddress("GainMean", drs_gainmean);
	drsfile.SetVecAddress("TriggerOffsetMean", drs_triggeroffsetmean);
	drsfile.GetRow(0); //Read the calibration data
	
	cout << "Reading calibration file successful..." << endl;
	return 0;
}
