#include <vector>
#include <deque>


#ifndef FAD_MAX_SAMPLES
	#warning FAD_MAX_SAMPLES not defined. defining: FAD_MAX_SAMPLES to 1024
	#define FAD_MAX_SAMPLES 1024
#endif

// source vector is
// float Ameas[FAD_MAX_SAMPLES];
void factfir(double b, vector<double> &a, int k, vector<float> &source, vector<float> &dest){
	//dest.clear();

	for (int slice =0; slice < FAD_MAX_SAMPLES; slice++) {
		float currentval = 0;

		for (int i=0; i < k ; i++){
			currentval += a[i] * source[ (slice - i + FAD_MAX_SAMPLES) % FAD_MAX_SAMPLES ];
		}
		dest[slice] = currentval / b;
	}
}

void sliding_avg(vector<float> &source, vector<float> &dest, unsigned int HalfWidth){
	// make local copy of source, in case source and dest are the same

	deque<float> local;
	local.insert(local.end(), source.begin(), source.end());
	// edge treatment.
	local.insert(local.begin(), HalfWidth, source[0]);
	local.insert(local.end(), HalfWidth, source[source.size()-1]);

	deque<float>::iterator it;

	dest.clear();

	float x;
	for (it=local.begin()+HalfWidth; it<local.end()-HalfWidth; ++it) {

		x=*it;
		float FullWidth = 2*HalfWidth+1;

		for ( unsigned int i=0; i < HalfWidth ; i++){
			x += *(it+i); // add the right neighbors
			x += *(it-i); // and don't forget the left neighbors on the left
		}

		dest.push_back(x/FullWidth);
	}
}

