#ifndef MARS_MWriteAsciiFile
#define MARS_MWriteAsciiFile

#ifndef MARS_MWriteFile
#include "MWriteFile.h"
#endif
#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

class MWriteAsciiFile : public MWriteFile
{
private:
    class MScale : public TNamed
    {
    private:
        Double_t fScale;
    public:
        MScale(const char *name, const char *title, Double_t scale)
            : TNamed(name, title), fScale(scale) {}
        Double_t GetScale() const { return fScale; }
    };

    ofstream *fOut;

    TObjArray fContNames;
    TObjArray fContainer;
    TObjArray fMembers;
    TObjArray fScale;

    TString fNameFile;

    virtual void   CheckAndWrite() const;
    virtual Bool_t IsFileOpen() const;
    virtual Bool_t GetContainer(MParList *pList);
    virtual const char *GetFileName() const { return fNameFile; }

    void Init(const char *filename, const char *name, const char *title);

public:
    MWriteAsciiFile(const char *filename, const char *contname,
                    const char *name=NULL, const char *title=NULL);
    MWriteAsciiFile(const char *filename, MParContainer *cont=NULL,
                    const char *name=NULL, const char *title=NULL);
    ~MWriteAsciiFile();

    void AddContainer(const char *cname, const char *member="", Double_t scale=1);
    void AddContainer(MParContainer *cont, const char *member="", Double_t scale=1);

    ClassDef(MWriteAsciiFile, 0) // Class to write one container to an ascii file
};

#endif
