#include <cstdio>
int FCalibrateEvent(vector<int16_t> &data, vector<int16_t> &data_offset, vector<float> &drs_basemean, vector<float> &drs_gainmean, vector<float> &drs_triggeroffsetmean, vector<float> &calevent, UInt_t data_px, UInt_t data_roi)
{
//-------------------------------------------
//Iterate over the pixels
//-------------------------------------------
	for (int j=0; j<data_px; j++)
	{
//-------------------------------------------
//Iterate over the slices
//-------------------------------------------
		for (UInt_t k=0; k<data_roi; k++)
		{
			UInt_t drs_calib_offset = (k+data_offset[j])%data_roi;
			float sample = (data[j*data_roi+k]*2000/4096.-drs_basemean[j*data_roi+drs_calib_offset]-drs_triggeroffsetmean[j*data_roi+k])/drs_gainmean[j*data_roi+drs_calib_offset]*1907.35;
//			float usample = data[j*data_roi+k]; //Uncalibrated sample value
			calevent[j*data_roi+k]=sample;
		}
//	cout << "Plotting successful..." << endl;
	}
	return 0;
}
