#include <cstdio>
#include "FCalibrateEvent.c"
#include <numeric>
int FOscilloscopeAllPx(fits &datafile, vector<int16_t> &data, vector<int16_t> &data_offset, unsigned int &data_num, UInt_t data_px, vector<float> &drs_basemean, vector<float> &drs_gainmean, vector<float> &drs_triggeroffsetmean, UInt_t data_roi, float threshold, TH1F* spectrum[])
//Data, calibration, data_roi, data_num, data_px, threshold, two histograms
{
	UInt_t start_sample = 10;
	UInt_t end_sample = data_roi-60;
	UInt_t min_dist = 150;
	UInt_t integration_size = 10;
	UInt_t integration_delay = 5;
	
	vector<float> calevent(data_px*data_roi); //Vector for the calibrated event
	
	float sample, last_sample, integral;
	UInt_t drs_calib_offset;

//**********************************************************************************	
	for (size_t i=0; i<datafile.GetNumRows(); i++)
	{
		datafile.GetRow(i);
		cout << "Event number: " << data_num << endl;
		
		FCalibrateEvent(data, data_offset, drs_basemean, drs_gainmean, drs_triggeroffsetmean, calevent, data_px, data_roi);
		
		//Iterate over the pixels
		for (int j=0; j<data_px; j++)
		{
//		size_t j=pixelnr; //Fix the Pixel to a SoftID
		
			//Iterate over the slices
			for (UInt_t k=start_sample; k<end_sample; k++)
			{
				if((calevent[j*data_roi+k-1]<threshold)&&(calevent[j*data_roi+k]>threshold))
				{
					integral = 0; //std::accumulate(calevent.begin()[k+integration_delay],calevent.begin()[k+integration_delay+integration_size]);
					for(UInt_t l=integration_delay; l<integration_delay+integration_size; l++)
					{
						integral+=calevent[j*data_roi+k+l];
					}
//					if((integral>60)&&(integral<=300)) {
//					if((integral>60)&&(integral<=300)) {
					//Iterate for the pulseshape
//					for(Int_t l=-10; l<60; l++)
//					{
//						drs_calib_offset = (k+l+data_offset[j])%data_roi;
//						sample = (data[j*data_roi+k+l]*2000/4096.-drs_basemean[j*data_roi+drs_calib_offset]-drs_triggeroffsetmean[j*data_roi+k+l])/drs_gainmean[j*data_roi+drs_calib_offset]*1907.35;
//					}
//					}
					spectrum[j]->Fill(integral);
					k+=min_dist;
				}
			}
		}
	}
	return 0;
}
