#include <TROOT.h>
#include <TCanvas.h>
#include <TProfile.h>

#include <stdint.h>
#include <cstdio>

#define HAVE_ZLIB
#include "fits.h"
#include "FOpenDataFile.c"
#include "FOpenCalibFile.c"
#include "FCalibrateEvent.c"

int calscope_batch(const char *name, const char *drsname, size_t pixelnr)
{
//******************************************************************************
//This program plots all calibrated events of a file when pressing ENTER to continue, a to abort.
//ATTENTION: only works for ROI=1024
// (array indices of the calibration wrong otherwise)
//Example call in ROOT:
//root [74] .x calscope_batch.C++("20110804_024.fits","20110804_023.drs.fits",10)
//T. Krähenbühl, August 2011, tpk@phys.ethz.ch
//******************************************************************************

	gROOT->SetStyle("Plain");
	
//-------------------------------------------
//Open the file
//-------------------------------------------
	fits datafile(name);
	if (!datafile)
	{
	cout << "Couldn't properly open the datafile." << endl;
	return 1;
	}
	
//-------------------------------------------
//Get the data
//-------------------------------------------
	vector<int16_t> data;
	vector<int16_t> data_offset;
	unsigned int data_num;
	size_t data_n;
	UInt_t data_px;
	UInt_t data_roi;
	FOpenDataFile(datafile, data, data_offset, data_num, data_n, data_roi, data_px);
	UInt_t maxeventnr = datafile.GetNumRows();
//-------------------------------------------
//Get the DRS calibration
//-------------------------------------------
	size_t drs_n;
	vector<float> drs_basemean;
	vector<float> drs_gainmean;
	vector<float> drs_triggeroffsetmean;
	FOpenCalibFile(drsname, drs_basemean, drs_gainmean, drs_triggeroffsetmean, drs_n);
	
//-------------------------------------------
//Check the sizes of the data columns
//-------------------------------------------
	if(drs_n!=data_n)
	{
		cout << "Data and DRS file incompatible (Px*ROI disagree)" << endl;
		return 1;
	}
	
//-------------------------------------------
//Create the title
//-------------------------------------------
	char title[500];
	vector<float> calevent(data_px*data_roi); //Vector for the calibrated event
	cout << "--------------------- Data --------------------" << endl;
	
	TCanvas *canv = new TCanvas( "canv", "Mean values of the first event", 100, 10, 700, 500 );
	std::sprintf(title,"Data: %s, DRS: %s, Px %i Ev %i",name,drsname,pixelnr,0);
	TProfile *pix = new TProfile("pix", title, 1024, -0.5, 1023.5);
	
//-------------------------------------------
//Start the loop
//-------------------------------------------
	char temp;
	std::cout << "Plot the spectra out of limits: Enter for next, 'a' to abort." << std::endl;
	for(int eventnr=0; eventnr<maxeventnr; eventnr++) {
		
		datafile.GetRow(eventnr);
		cout << "Event number: " << data_num << endl;

//-------------------------------------------
//Calibrate the event
//-------------------------------------------
		FCalibrateEvent(data, data_offset, drs_basemean, drs_gainmean, drs_triggeroffsetmean, calevent, data_px, data_roi);
		
//-------------------------------------------
//Draw the data
//-------------------------------------------
		pix->Reset();
		std::sprintf(title,"Data: %s, DRS: %s, Px %i Ev %i",name,drsname,pixelnr,eventnr);
		pix->SetTitle(title);
		for (UInt_t k=0; k<data_roi; k++)
		{
			pix->Fill(k,calevent[pixelnr*data_roi+k]);
		}
		
		pix->Draw();
		canv->Modified();
		canv->Update();
		
		temp='x';
		while ((temp!='\n') && (temp!='a'))
		    cin.get(temp);
		if(temp=='a') break;
	}
	
	return 0;
}
