

float getValue( int slice, int pixel,
	vector<float> &drs_basemean,
	vector<float> &drs_gainmean,
	vector<float> &drs_triggeroffsetmean,
	UInt_t RegionOfInterest,
	vector<int16_t> AllPixelDataVector,
	vector<int16_t> StartCellVector
){
	const float dconv = 2000/4096.0;

	float vraw, vcal;

	unsigned int pixel_pt;
	unsigned int slice_pt;
	unsigned int cal_pt;
	unsigned int drs_cal_offset;

	// printf("pixel = %d, slice = %d\n", slice, pixel);

	pixel_pt = pixel * RegionOfInterest;
	slice_pt = pixel_pt + slice;
	drs_cal_offset = ( slice + StartCellVector[ pixel ] )%RegionOfInterest;
	cal_pt    = pixel_pt + drs_cal_offset;

	vraw = AllPixelDataVector[ slice_pt ] * dconv;
	vcal = ( vraw - drs_basemean[ cal_pt ] - drs_triggeroffsetmean[ slice_pt ] ) / drs_gainmean[ cal_pt ]*1907.35;

	return( vcal );
}

size_t applyDrsCalibration( vector<float> &destination,
	int pixel,
	vector<float> &drs_basemean,
	vector<float> &drs_gainmean,
	vector<float> &drs_triggeroffsetmean,
	UInt_t RegionOfInterest,
	vector<int16_t> AllPixelDataVector,
	vector<int16_t> StartCellVector
){
	destination.clear();
	const float dconv = 2000/4096.0;
	float vraw, vcal;
	unsigned int pixel_pt;
	unsigned int slice_pt;
	unsigned int cal_pt;
	unsigned int drs_cal_offset;

	pixel_pt = pixel * RegionOfInterest;


	for ( unsigned int sl = 0; sl < RegionOfInterest; sl++){
		slice_pt = pixel_pt + sl;
		drs_cal_offset = ( sl + StartCellVector[ pixel ] )%RegionOfInterest;
		cal_pt    = pixel_pt + drs_cal_offset;

		vraw = AllPixelDataVector[ slice_pt ] * dconv;
		vcal = ( vraw - drs_basemean[ cal_pt ] - drs_triggeroffsetmean[ slice_pt ] ) / drs_gainmean[ cal_pt ]*1907.35;

		destination.push_back(vcal);
	}

	return destination.size();
}
