#ifndef MARS_MHillasSrc
#define MARS_MHillasSrc

#ifndef MARS_MHillas
#include "MHillas.h"
#endif

class MSrcPosCam;

class MHillasSrc : public MParContainer
{
private:
    const MHillas    *fHillas; //! Input parameters
    const MSrcPosCam *fSrcPos; //! Source position in the camere

    Float_t fAlpha;    // [deg]  angle of major axis with vector to src
    Float_t fDist;     // [mm]   distance from src to center of ellipse
    Float_t fHeadTail; // [mm]

public:
    MHillasSrc(const char *name=NULL, const char *title=NULL);

    void SetSrcPos(const MSrcPosCam *pos) { fSrcPos = pos; }
    const MSrcPosCam *GetSrcPos() const   { return fSrcPos; }

    Float_t GetLength()   const  { return fHillas->GetLength(); }
    Float_t GetWidth()    const  { return fHillas->GetWidth(); }
    Float_t GetDelta()    const  { return fHillas->GetDelta(); }
    Float_t GetSize()     const  { return fHillas->GetSize(); }
    Float_t GetMeanX()    const  { return fHillas->GetMeanX(); }
    Float_t GetMeanY()    const  { return fHillas->GetMeanY(); }
    Float_t GetAlpha()    const  { return fAlpha; }
    Float_t GetDist()     const  { return fDist; }
    Float_t GetHeadTail() const  { return fHeadTail; }

    void Print(Option_t *opt=NULL) const;

    virtual void Calc(const MHillas *hillas);

    virtual void AsciiRead(ifstream &fin);
    //virtual void AsciiWrite(ofstream &fout) const;

    ClassDef(MHillasSrc, 2) // Container to hold source position dependant parameters
};

/*
 Version 1: fAlpha, fDist
 Version 2: fAlpha, fDist, fSign
 */

#endif
