#include <TFile.h>
#include <TH2F.h>
#include <TH1D.h>
#include <TROOT.h>
#include <TF1.h>
#include <TTimer.h>
#include <TString.h>
#include <Getline.h>
#include <TCanvas.h>
#include <TGraph.h>
#include <TMultiGraph.h>

#include <iostream>
#include <fstream>
using namespace std;

int gainfit(
const char * InputRootFileName,
const char * OutTextFileName,
bool debug = false
) {

	TFile * tf = TFile::Open( InputRootFileName );
	TH2F *h = (TH2F*)gROOT->FindObject("hAmplSpek_cfd");

	TH1D *p1 = NULL;
	TH1D *p2  = NULL;
 
	TF1 *f_peaks = new TF1("total","[2]*TMath::Exp(-(x-[0])*(x-[0])/(2*[3]*[3])) "
																"+ [4]*TMath::Exp(-(x-[0]-[1])*(x-[0]-[1])/(2*[5]*[5])) "
																	"+ [6]*TMath::Exp((-x-[7])/[8])", 3, 23);
	Double_t par_init[9] = {8, 8, 1000 , 1 , 190 , 2, 30 , 5 , 10}; 	
	f_peaks->SetParameters(par_init);

	Int_t n = 1440;
	Double_t simple_gain[n];
	Double_t gain[n];
	Double_t pixelvec[n];
	for (int i=0; i<1440; i++){
		pixelvec[i]=i;
		simple_gain[i]=0;
		gain[i]=0;
	}
TGraph *gr1 = new TGraph(n,pixelvec,simple_gain);
TGraph *gr2 = new TGraph(n,pixelvec,gain);

	gr1->SetMarkerStyle(5);
	gr2->SetMarkerStyle(2);
	gr1->SetMarkerColor(kRed);
	gr2->SetMarkerColor(kBlack);
	gr1->SetMarkerSize(0.3);
	gr2->SetMarkerSize(0.3);
TMultiGraph *mg = new TMultiGraph();
mg->Add(gr1);
mg->Add(gr2);


	TCanvas *cGainFit = new TCanvas("cGainFit", "Fit of Amplitude Spektra", 0,0, 1000,500);
	cGainFit->Divide(1,2);

	// bad conding ... 1440 shouldn be hardcoded here
	for ( int pixelid =0; pixelid < 1440; pixelid++){
cout << "PID: " << pixelid << endl;
	p1 = h->ProjectionY("p1",pixelid+1, pixelid+1);
	p2 = (TH1D*) p1->Clone("p2");
	

	cGainFit->cd(1);
	p1->GetXaxis()->SetRangeUser( 2.5, 25);
	p1->Draw();

	Double_t peak[2];
	Double_t rms[2];

	peak[0]=  p1->GetBinCenter(p1->GetMaximumBin());
	rms[0] =  p1->GetRMS();
	cout << "1st position:" << peak[0] << endl;
	cout << "1st rms:" << rms[0] << endl;
	f_peaks->SetParameters(par_init);
	p1->Fit(f_peaks, "RQ");
	
	p2->GetXaxis()->SetRangeUser( peak[0] + 1.5*rms[0] , 25);

	peak[1] =  p2->GetBinCenter(p2->GetMaximumBin());
	rms[1] =  p2->GetRMS();
	cout << "2nd position:" << peak[1] << endl;
	cout << "2nd rms:" << rms[1] << endl;
	cout << "easy gain" << peak[1]-peak[0] << "\t\t";
	cout << "fittet gain" << f_peaks->GetParameter(1) << endl;

	simple_gain[pixelid]=peak[1]-peak[0];
	gain[pixelid] = f_peaks->GetParameter(1);
	gr1->SetPoint(pixelid, pixelvec[pixelid], simple_gain[pixelid]);
	gr2->SetPoint(pixelid, pixelvec[pixelid], gain[pixelid]);

cGainFit->cd(2);
mg->Draw("AP");
if (pixelid % 50 ==0){
	cGainFit->Modified();
	cGainFit->Update();
}
if(debug){
	cGainFit->Modified();
	cGainFit->Update();
				TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);
				timer.TurnOn();
				TString input = Getline("Type 'q' to exit, <return> to go on: ");
				timer.TurnOff();
				if (input=="q\n") {
					break;
				}
		}
	}

//tf->Close();	

ofstream out;
out.open( OutTextFileName );
out << "#" << InputRootFileName << endl;
out << "# PixelID : simple_gain : gain " << endl;
out << "# simple_gain is just the distance of the local maxima in the amplitude spektra " << endl;
out << "# gain is derived from a fit of two gaussians " << endl;
out << "# ---- the following line helps to use TTree::ReadFile, for reading again this txt file with root. " << endl;
out << "pixelID/I:simpleGain/F:Gain" << endl;
for (int i=0; i<1440; i++){
	out << pixelvec[i] << "\t" << simple_gain[i] << "\t" << gain[i] << endl;

} 
out.close();

return 0;
}
