

float getValue( int slice, int pixel,
	vector<float> &drs_basemean,
	vector<float> &drs_gainmean,
	vector<float> &drs_triggeroffsetmean,
	UInt_t RegionOfInterest,
	vector<int16_t> AllPixelDataVector,
	vector<int16_t> StartCellVector
){
	const float dconv = 2000/4096.0;

	float vraw, vcal;

	unsigned int pixel_pt;
	unsigned int slice_pt;
	unsigned int cal_pt;
	unsigned int drs_cal_offset;

	// printf("pixel = %d, slice = %d\n", slice, pixel);

	pixel_pt = pixel * RegionOfInterest;
	slice_pt = pixel_pt + slice;
	drs_cal_offset = ( slice + StartCellVector[ pixel ] )%RegionOfInterest;
	cal_pt    = pixel_pt + drs_cal_offset;

	vraw = AllPixelDataVector[ slice_pt ] * dconv;
	vcal = ( vraw - drs_basemean[ cal_pt ] - drs_triggeroffsetmean[ slice_pt ] ) / drs_gainmean[ cal_pt ]*1907.35;

	return( vcal );
}

size_t applyDrsCalibration( vector<float> &destination,
	int pixel, 
  int LeaveOutLeft, 
  int LeaveOutRight,
	vector<float> &drs_basemean,
	vector<float> &drs_gainmean,
	vector<float> &drs_triggeroffsetmean,
	UInt_t RegionOfInterest,
	vector<int16_t> AllPixelDataVector,
	vector<int16_t> StartCellVector
){
	// TODO this should be a parameter...
//	const int NumberOfPixel = 1440;

//	if ( RegionOfInterest < drs_triggeroffsetmean.size()/NumberOfPixel ){
//		cerr << "Error in applyDrsCalibration: ROI of data is:" << RegionOfInterest << endl;
//		cerr << "While ROI of 'TriggerOffset' is:" << drs_triggeroffsetmean.size()/NumberOfPixel << endl;
//		cerr << "Data ROI must be <= ROI of TriggerOffset. Aborting..." << endl;
//		return 0
//	}


	destination.clear();
	const float dconv = 2000/4096.0;
	float vraw, vcal;
	unsigned int pixel_pt;
	unsigned int slice_pt;
	unsigned int cal_pt;
	unsigned int drs_cal_offset;

	pixel_pt = pixel * RegionOfInterest;

//	unsigned int pixel_pt_TriggerOffset = pixel * drs_triggeroffsetmean.size()/NumberOfPixel;
//	unsigned int slice_pti_TriggerOffset;

	for ( unsigned int sl = LeaveOutLeft; sl < RegionOfInterest-LeaveOutRight ; sl++){
		slice_pt = pixel_pt + sl;
		//slice_pt_TriggerOffset =  pixel_pt_TriggerOffset + sl;	
		drs_cal_offset = ( sl + StartCellVector[ pixel ] ) % 1024;
		cal_pt    = pixel_pt + drs_cal_offset;

		vraw = AllPixelDataVector[ slice_pt ] * dconv;
		vcal = ( vraw - drs_basemean[ cal_pt ] - drs_triggeroffsetmean[ slice_pt ] ) / drs_gainmean[ cal_pt ]*1907.35;

		destination.push_back(vcal);
	}

	return destination.size();
}
