#!/bin/bash

date=`date +%Y/%m/%d --date="-1day"`

today=`date +%F`
logfile=/home/`whoami`/DataCheck/log/RsyncAux$today.log

auxdir=loc_data/aux/$date
echo `date`": processing files in "$auxdir >> $logfile 2>&1

#rsync from daq to data
if ! /usr/bin/rsync -avxH 10.0.100.12::$auxdir /$auxdir >> $logfile 2>&1
then
   echo `date`": problem rsyncing auxiliary data from daq to data"
fi


