#!/bin/bash

date=`date +%Y/%m/%d --date="-1day"`

today=`date +%F`
logfile=/home/`whoami`/DataCheck/log/RsyncRaw$today.log

rawdir=loc_data/raw/$date
echo `date`": processing files in "$rawdir >> $logfile 2>&1

#rsync from daq to data
if ! /usr/bin/rsync -avxH 10.0.100.12::$rawdir /$rawdir >> $logfile 2>&1
then
   echo `date`": problem rsyncing rawdata from daq to data"
fi


