#!/bin/bash

date=`date +%Y/%m/%d --date="-1day"`

today=`date +%F`
logfile=/home/`whoami`/DataCheck/log/RsyncAux$today.log

auxdir=loc_data/aux/$date
echo ""
echo ""
echo ""
echo `date`": processing files in "$auxdir >> $logfile 2>&1

hour=`date +%k`
if [ $hour -lt 8 ] || [ $hour -gt 18 ]
then
   bwlimit="--bwlimit=2000"
   echo "rsync data with "$bwlimit >> $logfile 2>&1
else 
   echo "rsync data without bwlimit" >> $logfile 2>&1
fi

#rsync from daq to data
if ! /usr/bin/rsync -avxHP $bwlimit 10.0.100.12::$auxdir /$auxdir >> $logfile 2>&1
then
   echo `date`": problem rsyncing auxiliary data from daq to data"
fi


