#!/bin/bash

date=`date +%Y/%m/%d --date="-1day"`

today=`date +%F`
logfile=/home/`whoami`/DataCheck/log/RsyncRaw$today.log

echo ""
echo ""
echo ""
rawdir=loc_data/raw/$date
echo `date`": processing files in "$rawdir >> $logfile 2>&1

hour=`date +%k`
if [ $hour -lt 8 ] || [ $hour -gt 18 ]
then
   bwlimit="--bwlimit=20000"
   echo "rsync data with "$bwlimit >> $logfile 2>&1
else 
   echo "rsync data without bwlimit" >> $logfile 2>&1
fi

#rsync from daq to data
if ! /usr/bin/rsync -avxHP $bwlimit 10.0.100.12::$rawdir /$rawdir >> $logfile 2>&1
then
   echo `date`": problem rsyncing rawdata from daq to data"
fi


