#!/bin/bash

date=`date +%Y/%m/%d --date="-1day"`

today=`date +%F`
logfile=/home/`whoami`/DataCheck/log/RsyncRaw$today.log

echo "" >> $logfile 2>&1
echo "" >> $logfile 2>&1
echo "" >> $logfile 2>&1
# raw data directories on data 
rawdirdaq=/daq/raw/$date/ # /loc_data from daq via nfs on data
rawdirdata=/loc_data/raw/$date 
echo `date`": processing files in "$rawdir >> $logfile 2>&1

# get current hour
hour=`date +%k`
# define bwlimit for rsync depending on the time
if [ $hour -lt 8 ] || [ $hour -gt 18 ]
then
   # limit bw for rsync to 20 MB/s during night
   bwlimit="--bwlimit=20000"
   echo "rsync data with "$bwlimit >> $logfile 2>&1
else 
   # no bw limit during day
   echo "rsync data without bwlimit" >> $logfile 2>&1
fi

#rsync from daq to data
if ! /usr/bin/rsync -avxHP $bwlimit $rawdirdaq $rawdirdata >> $logfile 2>&1
then
   echo `date`": problem rsyncing rawdata from daq to data"
fi


