#!/usr/bin/python
#
#

import glob
from os import system

# zipped or unzipped data ?
zip = '.gz' # set to '' for unzipped data

# path to the raw data: zipped /data00  unzipped /data03 !!!
path = '/data00/fact-construction/raw/'

# where to store the results and how to tag them
respath = '../res/' # the path to the store for the results
restag = 'bsl'      # the tag for identifying the type of analysis run on the data
rmname = 'fbsl.C'   # the root macro to run for the analysis
rmpath = '../rootmacros/'        # path to the root macro
rmacro = rmpath + rmname + '++'  # compose the macro name (++ instructs root to compile it first)

# the list of runs which should be processed ( could later be read from a file...)
# format: ( 'drsfileID = BBB', 'datafileid = AAA', 'DD', 'MM', 'YYYY' )
# example: 20111109_003.fits = YYYYMMDD_AAA.fits
# example: 20111109_003.drs.fits = YYYYMMDD_BBB.fits

runlist = []

#runlist.append( ( '003', '003', '09', '11', '2011') )
#runlist.append( ( '003', '004', '09', '11', '2011') )
#runlist.append( ( '003', '005', '09', '11', '2011') )
runlist.append( ( '003', '006', '09', '11', '2011') )
runlist.append( ( '003', '007', '09', '11', '2011') )
runlist.append( ( '017', '008', '09', '11', '2011') )
runlist.append( ( '017', '010', '09', '11', '2011') )
runlist.append( ( '017', '011', '09', '11', '2011') )
runlist.append( ( '017', '012', '09', '11', '2011') )
runlist.append( ( '017', '013', '09', '11', '2011') )
runlist.append( ( '017', '014', '09', '11', '2011') )
runlist.append( ( '017', '017', '09', '11', '2011') )
runlist.append( ( '017', '018', '09', '11', '2011') )

# iterate over the list of runs
for run in runlist:

    # decompose the run info
    drs, data, day, month, year =  run

    # set the path to the data 
    dpath = path + year +'/' + month + '/' + day + '/'
    print 'working on datapath: ', dpath

    # generate the input file names (data and drs calibration)
    dfname = year + month + day + '_' + data
    drsfname = year + month + day + '_' + drs
    dfile =  dpath + dfname + '.fits' + zip
    drsfile = dpath + drsfname +'.drs.fits' + zip
    print 'data file: ', dfile
    print 'drs file : ', drsfile

    # generate the file names for stroning the results
    resdfile = respath + dfname + '_' + restag + '.txt'
    reshfile = respath + dfname + '_' + restag + '.root'
    print 'result data file: ', resdfile
    print 'result historgram file: ', reshfile

    # compose the command and run it
    cmd = 'root -b -q \'' + rmacro + '(\"' + dfile + '\", \"' + drsfile + '\", 0, -1, 0, -1, \"' + resdfile + '\", \"' + reshfile + '\") \' '
    print 'execution cmd: ', cmd
    system( cmd )

