#!/usr/bin/python26
#
# FACT SLOW CONTROL DATA
# FSC_CONTROL_TEMPERATURE DATA
#
# Plot temperatures versus time
# Save plots to disk
#
# Werner Lustermann
# ETH Zurich

import pyfits # module for reading fits files
 
import numpy as np
import numpy.ma as ma # masked array module

import matplotlib.pyplot as plt # for plotting

class FSC_TEMPERATURE( object ):
  
    def __init__(self, dpath = '../temperature/', dfile = '20111103.FSC_CONTROL_TEMPERATURE.fits', plot_groups = True, show_plots = True ):
    
        self.dfile = dfile
        self.dpath = dpath
        self.fname = dpath + dfile

        self.Tgroups = ['T_sens', 'T_ps', 'T_crate', 'T_eth', 'T_back', 'T_aux' ]
        self.rData()

    def rData( self ):

        try:
            hdu = pyfits.open( self.fname )
        except:
            print 'file: ', fname, ' does not exist! ==> BREAK!!!'
            exit( 'unknown data file' )

        self.tbdata = hdu[1].data
        hdu.close()

        t  = self.tbdata.field( 'Time' )
        tt = np.modf( t )[0] * 24. 
        # self.time = np.roll( tt, len( t[ t<12.] ) )
        for i in range( len( tt[ tt >= 12.] ) + 1, len( tt ) ): tt[i] += 24. 
        self.time = tt

    def tplot_group( self, mT, gr ):
        """ plot maxumum, minimum and mean of a group of sensors """
        ax = plt.subplot(111)
        ax.plot( self.time, np.max(mT, 1),  'b.', label = 'max', markersize = 1 )
        ax.plot( self.time, np.min(mT, 1),  'b.', label = 'min', markersize = 1 )
        ax.plot( self.time, np.mean(mT, 1),  'r.', label = 'mean', markersize = 1 )

        ax.grid( 'on' )
        plt.title( 'Temperatures: ' + gr + '  ' + self.dfile[0:12], fontsize = 18 )
        plt.xlabel( 'time', fontsize = 14 )
        plt.ylabel( 'T in degC', fontsize = 14 )
        #plt.legend( loc = 4 )
    
        # Shink current axis by 20%
        box = ax.get_position()
        ax.set_position([box.x0, box.y0, box.width * 0.9, box.height])
        plt.legend( fancybox=True, loc='center left', bbox_to_anchor=(1, 0.5), numpoints = 7 )
#
    def plot_groups( self ):
        for i,group in enumerate( self.Tgroups ):
            T     = self.tbdata.field( group )
            maska = self.tbdata.field( group ) == 0.0 
            maskb = self.tbdata.field( group ) > 50.
            mask  = maska | maskb
            mT    = ma.masked_array( T, mask )
            
            plt.figure()

            self.tplot_group( mT, group )
            plt.savefig( self.dpath + self.dfile[0:-5] + '_' + group + '.png')


#
#
    def plot_means( self ):
   
        fig = plt.figure()
        ax = plt.subplot(111)
        box = ax.get_position()
        ax.set_position([box.x0, box.y0, box.width * 0.97, box.height])


        for i,group in enumerate( self.Tgroups ):
  
            #print 'i = ', i, group
            T     = self.tbdata.field( group )
            maska = self.tbdata.field( group ) == 0.0
            maskb = self.tbdata.field( group ) > 50.
            mask  = maska | maskb
            mT    = ma.masked_array( T, mask )

            ax.plot( self.time, np.mean(mT, 1) , '.', label = group, markersize = 2 )
    
            ax.grid( 'on' )
            plt.title( 'Mean Temperatures: ' + self.dfile[0:12], fontsize = 18 )
            plt.xlabel( 'time', fontsize = 14 )
            plt.ylabel( 'T in degC', fontsize = 14 )

            # Shink current axis by 20%
            box = ax.get_position()
            ax.set_position([box.x0, box.y0, box.width * 0.97, box.height])
            plt.legend( fancybox=True, loc='center left', bbox_to_anchor=(1, 0.5), numpoints = 7 )
            plt.savefig( self.dpath + self.dfile[0:-5] + '_means' + '.png' )
           

    def show_plot( self ):
        plt.show()

if __name__ == '__main__':
        
    print 'FACT FSC_CONTROL TEMPERATURE DATA'
    
    fsct = FSC_TEMPERATURE()
    fsct.plot_means()
    fsct.plot_groups()
    fsct.show_plot()
    



    
    
