#!/usr/bin/python26
#
# FACT SLOW CONTROL DATA
# FSC_CONTROL_TEMPERATURE DATA
#
# Plot temperatures versus time
# Save plots to disk
#
# Werner Lustermann
# ETH Zurich

import pyfits # module for reading fits files
 
import numpy as np
import numpy.ma as ma # masked array module

import matplotlib.pyplot as plt # for plotting

class FSC_VOLTAGE( object ):
  
    def __init__(self, dpath = '../voltage/', dfile = '20111102.FSC_CONTROL_VOLTAGE.fits', plot_groups = True, show_plots = True ):
    
        self.dfile = dfile
        self.dpath = dpath
        self.fname = dpath + dfile

        self.Dgroups = ['FAD_Ud', 'FAD_U+', 'FAD_U-', 'FPA_Ud', 'FPA_U+', 'FPA_U-', 'ETH_U', 'FTM_U', 'FFC_U', 'FLP_U' ] 
        # self.Dgroups = ['FAD_Ud', 'FAD_U+', 'FAD_U-', 'FPA_Ud', 'FPA_U+', 'FPA_U-', 'ETH_U', 'FTM_U' ] 
       
        self.rData()

    def rData( self ):

        try:
            hdu = pyfits.open( self.fname )
        except:
            print 'file: ', fname, ' does not exist! ==> BREAK!!!'
            exit( 'unknown data file' )

        self.tbdata = hdu[1].data
        hdu.close()

        self.time  = self.tbdata.field( 'Time' )
#
#
#
    def vplot_all( self ):

        for i, group in enumerate( self.Dgroups ):
  
            #print 'i = ', i, group
            T     = self.tbdata.field( group )
            # maska = self.tbdata.field( group ) == 0.0
            # maskb = self.tbdata.field( group ) > 50.
            # mask  = maska | maskb
            # mT    = ma.masked_array( T, mask )
            mT = T
            
            plt.figure(111)
            ax = plt.subplot(111)
            if i < 8:
                ax.plot( self.time, np.mean(mT,1) , '.', label = group, markersize = 2 )
            else:
                ax.plot( self.time, mT , '.', label = group, markersize = 2 )

            ax.grid( 'on' )
            plt.title( 'DC Voltages: ' + self.dfile[0:12], fontsize = 18 )
            plt.xlabel( 'time', fontsize = 14 )
            plt.ylabel( 'Voltage in V', fontsize = 14 )

            # Shink current axis by 20%
            box = ax.get_position()
            ax.set_position([box.x0, box.y0, box.width * 0.97, box.height])
            plt.legend( fancybox=True, loc='center left', bbox_to_anchor=(1, 0.5), numpoints = 7 )
            plt.savefig( self.dfile[0:-5] + '.png' )
            
            

    def tshow_plots( self ):
        plt.show()

if __name__ == '__main__':
        
    print 'FACT FAD_CONTROL TEMPERATURE DATA'
    
    fadt = FSC_VOLTAGE()
    fadt.vplot_all()
    #fadt.tshow_plots()
    
    #fadt = FSC_VOLTAGE()
    #fadt.vplot_all()
    #fadt.tshow_plots()
    



    
    
