#!/usr/bin/python26

import glob
from os import path
from os import system

#import pyfits

from fscvolt1 import FSC_VOLTAGE
from fsc3 import FSC_TEMPERATURE

class PAUX( object ):
  
    def __init__( self, year = 2011, month = 11, day = 0, dpoff = '../' ):

        self.year = str( year )
        self.month = str( month )
        self.day = str( day )
        self.dpoffset = dpoff 
        
    def anatemp( self ):
    
        # fsc temperatures
        self.dpath = '../temperature/'
        self.searchpath = self.dpath + self.year + self.month + '*.FSC_CONTROL_TEMPERATURE.fits'
        print 'searchpath', self.searchpath
        dflist = glob.glob( self.searchpath )        
        print 'dflist', dflist, 'shape: ', len(dflist)
        for i, file in enumerate( dflist ):
            file = file[15:]
            print 'file: ', i, ': ', file
            tdata = FSC_TEMPERATURE( dpath = self.dpath, dfile = file )
            tdata.plot_means()
            tdata.plot_groups()
        
    
    def anavolt( self ):
    
        # fsc voltages
        self.dpath = '../voltage/'
        self.searchpath = self.dpath + self.year + self.month + '*.FSC_CONTROL_VOLTAGE.fits'
        # print 'searchpath', self.searchpath
        dflist = glob.glob( self.searchpath )        
        #print 'dflist', dflist, 'shape: ', len(dflist)
        for i, file in enumerate( dflist ):
            print 'file: ', i, ': ', file
            vdata = FSC_VOLTAGE( dpath = self.dpath, dfile = file )
            vdata.vplot_all()
            del vdata
            
     
            
            
if __name__ == '__main__':
        
    print 'FACT SLOW CONTROL DATA: PAUX'
    
    paux = PAUX(2011, 11)
    paux.anatemp()
    
