#!/bin/bash

today=`date +%F`
logfile=/home/`whoami`/DataCheck/log/CheckRaw$today.log

skipmd5sum="no" # fill md5 sums in any case
skipmd5sum="iffilled" # fill md5 sum only if they are not yet in db
#skipmd5sum="yes" # do not fill md5 sums in any case

doupdate="yes" # update all entries
doupdate="no" # fill only entries which are not yet existing

fillonly="ifzipped" # fill only entries which are not yet existing + where zipped file is availabl

echo ""  >> $logfile 2>&1
echo ""  >> $logfile 2>&1
echo ""  >> $logfile 2>&1
echo `date`"executing "$0"..." >> $logfile 2>&1
echo "=====> doupdate: "$doupdate >> $logfile 2>&1
echo "=====> skipmd5sum: "$skipmd5sum >> $logfile 2>&1
echo "=====> fillonly: "$fillonly >> $logfile 2>&1

password=`cat /home/fact/DataCheck/.pw`
if [ "$password" == "" ]
then
   echo "please insert password in .pw file"
fi

# setup to use ftools
export HEADAS=/opt/heasoft-6.11/x86_64-unknown-linux-gnu-libc2.13-0/
source $HEADAS/headas-init.sh

# get last 2 nights
dates=( `date +%Y/%m/%d --date="-12hour"` `date +%Y/%m/%d --date="-36hour"` )

# do rsync for rawfiles of these dates
for date in ${dates[@]}
do 
   echo "" >> $logfile 2>&1
   echo "" >> $logfile 2>&1
   echo "" >> $logfile 2>&1
   rawdir=/loc_data/raw/$date
   runnumber=`echo $date | sed -e 's/\///g'`
   echo `date`": processing files in "$rawdir >> $logfile 2>&1
   # check if data are available from that night
   if ! [ -d $rawdir ]
   then
      echo `date`": no data available in "$rawdir >> $logfile 2>&1
      continue
   fi

   # find all fits-files starting with the oldest file
   echo `date`": finding files to be zipped in $rawdir..." >> $logfile 2>&1
   fitsfiles=`find $rawdir -type f -name '*.fits'| sort `

   # loop to zip files
   echo `date`": checking files in $rawdir..." >> $logfile 2>&1
   for file in $fitsfiles
   do
      echo "" >> $logfile 2>&1
      echo "checking file "$file >> $logfile 2>&1
      # check if raw file was changed in the last 30 minutes
      isnew=`find $file -cmin -30`
      if [ "$isnew" != "" ]
      then
         echo $file" is not older than 30 min => continue" >> $logfile 2>&1
         continue
      fi

      # check if it is drs file
      isnew=`ls $file | grep drs`
      if [ "$isnew" != "" ]
      then
         echo $file" is a drs file => continue" >> $logfile 2>&1
         continue
      fi

      # check if file is already finished
      # original file on daq (if data was taken on daq
      origfile=`echo $file | sed -e 's/loc_data/daq/'`
      if [ -e $origfile ]
      then
         # get time of last modification as seconds since Epoch for both files
         timeorig=`stat -c %Y $origfile`
         timecopy=`stat -c %Y $file`
         # compare times
         if ! [ $timeorig -eq $timecopy ]
         then
            # if times are not the same, the file is still open => no zip
            echo `date`": file "$file" not yet closed => continue" >> $logfile 2>&1
            continue
         fi
      else
         # if the origfile doesn't exist, the data was probably written not on daq but on data
         echo `date`": file "$file" was probably taken on data and not daq " >> $logfile 2>&1
      fi
      
      # get run and file number form filename
      runnumbererror="no"
      numbererror="no"
      numberfromname=`echo $file | grep -E -o '20[1-9][0-9][01][0-9][0-3][0-9]_[0-9]{3}'`
      runnumberfromname=`echo $numberfromname | cut -d_ -f1`
      filenumberfromname=`echo $numberfromname | cut -d_ -f2 | sed -e 's/^0//g' -e 's/^0//g'`
      if [ "$runnumber" != "$runnumberfromname" ]
      then
         runnumbererror="yes"
         echo "ERROR: for file "$file" runnumber from date and filename don't agree ("$runnumber" - "$runnumberfromname")"
         echo "ERROR: for file "$file" runnumber from date and filename don't agree ("$runnumber" - "$runnumberfromname")" >> $logfile 2>&1
      fi
      
      # check if entry already exists
      query3="SELECT fRunNumber FROM RunInfo WHERE Concat(fRunNumber, '_', LPAD(fFileNumber, 3, 0))='"$numberfromname"'"
      echo "Q3:"$query3 >> $logfile 2>&1 2>&1
      result3=`/usr/bin/mysql -u operator --host=fact01.fact.local --password=$password FactData -e "$query3" 2>> $logfile`

      # only proceed with file 
      #  if information is not yet in database
      #  and no update is wished ($doupdate)
      if [ "$result3" != "" ] && [ "$doupdate" == "no" ]
      then 
         echo $file" has been inserted already => continue " >> $logfile 2>&1
         continue
      fi
      
      # check if entry has already checksums
      query5="SELECT fRunNumber FROM RunInfo WHERE Concat(fRunNumber, '_', LPAD(fFileNumber, 3, 0))='"$numberfromname"'"
      query5=$query5" AND NOT ISNULL(fMd5sumRaw) AND NOT ISNULL(fMd5sumRawZip)"
      echo "Q5:"$query5 >> $logfile 2>&1 
      result5=`/usr/bin/mysql -u operator --host=fact01.fact.local --password=$password FactData -e "$query5" 2>> $logfile`

      # get md5sums of raw and zip file
      #   to safe time for tests and update this can be skipped ($skipmd5sum)
      md5sum=
      md5sumzip=
      if [ "$skipmd5sum" == "no" ] || [ "$skipmd5sum" == "iffilled" ]
      then
         #echo "skip: "$skipmd5sum >> $logfile 2>&1
         #echo "res5: -"$result5"-" >> $logfile 2>&1
         #if [ "$skipmd5sum" == "no" ] || [ "$result5$skipmd5sum" == "iffilled" ] 
         if [ "$skipmd5sum" == "no" ] || [ "$result5" == "" ] 
         then 
            zipfile=`echo $file | sed -e 's/raw/zipraw/' -e 's/fits/fits.gz/'`
            # only do the md5sum if the zipfile is already available
            if ls $zipfile >/dev/null >> $logfile 2>&1 
            then 
               echo "calculation md5sum for raw..." >> $logfile 2>&1
               md5sum=`md5sum $file | cut -d' ' -f1`
               echo "calculation md5sum for zipraw..." >> $logfile 2>&1
               md5sumzip=`md5sum $zipfile | cut -d' ' -f1`
            fi
         fi
      fi
      if [ "$result3" == "" ] && [ "$md5sum" == "" ] && [ "$fillonly" == "ifzipped" ]
      then 
         echo $file" is still missing zip => do not insert yet => continue " >> $logfile 2>&1
         continue
      fi

      runtype=
      # check if fits file is corrupted
      numfitserrors=0
      checkfitsfile=`fverify $file  2>> $logfile | grep '0 error(s)'`
      if [ "$checkfitsfile" == "" ]
      then
         numfitserrors=1
      fi

      if [ $numfitserrors -eq 0 ]
      then 
         # get run and file number from file
         runnumberfromfile=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep NIGHT | grep -E -o '20[1-9][0-9][01][0-9][0-3][0-9]'`
         filenumberfromfileorig=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep RUNID | grep -E -o '[0-9]{1,3}'`
         numberfromfile=$runnumberfromfile"_"`printf %03d $filenumberfromfileorig`
         # compare numbers
         if [ "$numberfromfile" != "$numberfromname" ]
         then
            numbererror="yes"
            echo "ERROR: for file "$file" number from filename and file don't agree ("$numberfromname" -"$numberfromfile")"
            echo "ERROR: for file "$file" number from filename and file don't agree ("$numberfromname" -"$numberfromfile")" >> $logfile 2>&1
         fi
      
         # check if this run has drs file
         drsfile=`echo $file | sed -e 's/fits/drs.fits/'`
         numdrsfiles=`ls $drsfile 2>/dev/null | wc -l`
         
         # get other variables from header 
         runtype=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep RUNTYPE | grep -E -o "['][a-z-]+[']" | sed -e "s/'//g"`
         roi=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep NROI | grep -v NROITM | grep -E -o '[0-9]{1,4}'`
         roitm=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep NROITM | grep -E -o '[0-9]{1,4}'`
         numevents=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep Events | grep -E -o '[0-9]+'`
         numphys=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep 'NTRG ' | grep -E -o '[0-9]+'`
         numext1=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep 'NTRGEXT1' | grep -E -o '[ ][0-9]+[ ]' | sed -e 's/\ //g'`
         numext2=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep 'NTRGEXT2' | grep -E -o '[ ][0-9]+[ ]' | sed -e 's/\ //g'`
         numelp=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep 'NTRGLPE' | grep -E -o '[0-9]+'`
         numilp=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep 'NTRGLPI' | grep -E -o '[0-9]+'`
         numoth=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep 'NTRGMISC' | grep -E -o '[0-9]+'`
         numped=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep 'NTRGPED' | grep -E -o '[0-9]+'`
         numtime=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep 'NTRGTIM' | grep -E -o '[0-9]+'`
         # in newest data start time is in DATE-OBS
         # in older data start time is in TSTART
         # in the beginning TSTART was empty
         runstart=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep DATE-OBS | grep -E -o '20[1-9][0-9][\-][01][0-9][\-][0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9][.][0-9]{6}'`
         runstart2=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep TSTART | grep -E -o '20[1-9][0-9][\-][01][0-9][\-][0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9][.][0-9]{6}'`
         if [ "$runstart" == ""  ]
         then
            if [ "$runstart2" == ""  ]
            then
               runstart=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep DATE | grep -v 'DATE-' | grep -E -o '20[1-9][0-9][\-][01][0-9][\-][0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9][.][0-9]{6}'`
            else
               runstart=$runstart2
            fi
         fi
         # in newest data start time is in DATE-END
         # in older data start time is in TSTOP
         # in the beginning TSTOP was empty
         runstop=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep DATE-END | grep -E -o '20[1-9][0-9][\-][01][0-9][\-][0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9][.][0-9]{6}'`
         runstop2=`/home/fact/FACT++/fitsdump -h -t Events $file  2>/dev/null | grep TSTOP | grep -E -o '20[1-9][0-9][\-][01][0-9][\-][0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9][.][0-9]{6}'`
         if [ "$runstop" == ""  ]
         then
            if [ "$runstop2" == ""  ]
            then
               runstop=`stat $file  2>/dev/null | grep Modify | grep -E -o '20[1-9][0-9][\-][01][0-9][\-][0-3][0-9][ ][0-2][0-9]:[0-6][0-9]:[0-6][0-9][.][0-9]{9}'`
            else
               runstop=$runstop2
            fi
         fi
      fi
      
      # set runtype to 'unknown' if no runtype could be queried
      if [ "$runtype" == "" ]
      then
         runtype="n/a"
      fi
      # on 15.11.2011 the runtypes had different names
      if [ "$date" == "2011/11/15" ]
      then
         if [ "$runtype" == "drs-calib" ]
         then
            runtype="drs-gain"
         fi
         if [ "$runtype" == "drs-time-calib" ]
         then
            runtype="drs-time"
         fi
         if [ "$runtype" == "pedestal" ]
         then
            runtype="drs-pedestal"
         fi
         if [ "$runtype" == "light-pulser" ]
         then
            runtype="light-pulser-ext"
         fi
         if [ "$runtype" == "pedestal-on" ]
         then
            runtype="pedestal"
         fi
      fi
      # get runtype
      query2="SELECT fRunTypeKEY FROM RunType WHERE fRunTypeName='"$runtype"'"
      echo "Q2:"$query2 >> $logfile 2>&1
      result2=( `/usr/bin/mysql -u operator --host=fact01.fact.local --password=$password FactData -e "$query2" 2>> $logfile` )
      if [ ${#result2} -eq 0 ]
      then 
         echo $numberfromname": Could not query fRunTypeKey for runtype "$runtype
         echo $numberfromname": Could not query fRunTypeKey for runtype "$runtype >> $logfile 2>&1
         exit
      fi

      # insert or update depending on whether run exists
      if [ "$result3" == "" ]
      then 
         query4="INSERT"
         querymid=" fRunNumber="$runnumber", fFileNumber="$filenumberfromname", "
         querystop=
      else
         query4="UPDATE"
         querymid=
         querystop=" WHERE fRunNumber="$runnumber" AND fFileNumber="$filenumberfromname
      fi
      query4=$query4" RunInfo SET "$querymid" fRunTypeKey="${result2[1]}
      if [ $numfitserrors -eq 0 ]
      then 
         query4=$query4", fNumEvents="$numevents", fROI="$roi", fROITimeMarker="$roitm
         query4=$query4", fRunStart='"$runstart"', fRunStop='"$runstop"'"
         if [ "$numphys" != "" ]
         then
            query4=$query4", fNumPhysicsTrigger="$numphys
         fi
         if [ "$numext1" != "" ]
         then
            query4=$query4", fNumExt1Trigger="$numext1
         fi
         if [ "$numext2" != "" ]
         then
            query4=$query4", fNumExt2Trigger="$numext2
         fi
         if [ "$numelp" != "" ]
         then
            query4=$query4", fNumELPTrigger="$numelp
         fi
         if [ "$numilp" != "" ]
         then
            query4=$query4", fNumILPTrigger="$numilp
         fi
         if [ "$numped" != "" ]
         then
            query4=$query4", fNumPedestalTrigger="$numped
         fi
         if [ "$numtime" != "" ]
         then
            query4=$query4", fNumTimeTrigger="$numtime
         fi
         if [ "$numoth" != "" ]
         then
            query4=$query4", fNumOtherTrigger="$numoth
         fi
      fi
      if [ "$md5sum" != "" ]
      then
         query4=$query4", fMd5sumRaw='"$md5sum"', fMd5sumRawZip='"$md5sumzip"'"
         query4=$query4", fHasDrsFile="$numdrsfiles
      fi
      query4=$query4", fFitsFileErrors="$numfitserrors
      query4=$query4" "$querystop
      echo "Q4:"$query4 >> $logfile 2>&1
      if ! /usr/bin/mysql -u operator --host=fact01.fact.local --password=$password FactData -e "$query4" >> $logfile 2>&1
      then
         echo "insert/update of "$numfromfile" to mysql failed" >> $logfile 2>&1
      fi

      # print summary for debug
      echo "*******"  >> $logfile 2>&1
      echo "summary for file "$file >> $logfile 2>&1
      echo "*******"  >> $logfile 2>&1
      echo "  errors: "$numfitserrors" (1 means errors exist)" >> $logfile 2>&1
      echo "  number of drs files: "$numdrsfiles >> $logfile 2>&1
      echo "  runnumber error: "$runnumbererror >> $logfile 2>&1
      echo "  number error: "$numbererror >> $logfile 2>&1
      echo "  roi: "$roi >> $logfile 2>&1
      echo "  roitm: "$roitm >> $logfile 2>&1
      echo "  runtype: "$runtype >> $logfile 2>&1
      echo "  numevents: "$numevents >> $logfile 2>&1
      echo "  md5sum: "$md5sum >> $logfile 2>&1
      echo "  md5sum(zip): "$md5sumzip >> $logfile 2>&1
      echo "  start: "$runstart >> $logfile 2>&1
      echo "  stop: "$runstop >> $logfile 2>&1

      # missing
      # check wether entry has been made (status table)
   done
done


