#!/bin/bash

today=`date +%F`
logfile=/home/`whoami`/DataCheck/log/FillAuxData$today.log

# steps: 
#  select run# from DB - no, date is given
#  get daily files
#  select file# from DB
#  select start and stop from DB
#  get info from files
#  fill into into DB


doupdate="yes" # update all entries
doupdate="no" # fill only entries which are not yet existing

echo ""  >> $logfile 2>&1
echo ""  >> $logfile 2>&1
echo ""  >> $logfile 2>&1
echo `date`"executing "$0"..." >> $logfile 2>&1
echo "=====> doupdate: "$doupdate >> $logfile 2>&1

password=`cat /home/fact/DataCheck/.pw`
if [ "$password" == "" ]
then
   echo "please insert password in .pw file"
fi

# setup to use ftools
export HEADAS=/opt/heasoft-6.11/x86_64-unknown-linux-gnu-libc2.13-0/
source $HEADAS/headas-init.sh

# get last 2 nights
dates=( `date +%Y/%m/%d --date="-12hour"` `date +%Y/%m/%d --date="-36hour"` )
dates=( "2011/11/15" )

# do rsync for rawfiles of these dates
for date in ${dates[@]}
do 
   echo "" >> $logfile 2>&1
   echo "" >> $logfile 2>&1
   echo "" >> $logfile 2>&1
   auxdir=/loc_data/aux/$date
   runnumber=`echo $date | sed -e 's/\///g'`
   echo `date`": processing files in "$auxdir >> $logfile 2>&1
   # check if data are available from that night
   if ! [ -d $auxdir ]
   then
      echo `date`": no data available in "$auxdir >> $logfile 2>&1
      continue
   fi

   # get daily fits files 
   trackingfile=$auxdir/$runnumber.DRIVE_CONTROL_TRACKING_POSITION.fits
   if ! [ -e $trackingfile ]
   then 
      echo $trackingfile" not found"
   fi
   triggerratefile=$auxdir/$runnumber.FTM_CONTROL_TRIGGER_RATES.fits
   if ! [ -e $triggerratefile ]
   then 
      echo $triggerratefile" not found"
   fi
   thresholdfile=$auxdir/$runnumber.FTM_CONTROL_STATIC_DATA.fits
   if ! [ -e $thresholdfile ]
   then 
      echo $thresholdfile" not found"
   fi
   biascontrolfile=$auxdir/$runnumber.BIAS_CONTROL_VOLTAGE.fits
   if ! [ -e $biascontrolfile ]
   then 
      echo $biascontrolfile" not found"
   fi

   # get file numbers from DB
   query1="SELECT fFileNumber from RunInfo WHERE fRunNumber="$runnumber
   filenumbers=( `/usr/bin/mysql -u operator --host=fact01.fact.local --password=$password FactData -s -e "$query1" 2>> $logfile` )
   for filenum in ${filenumbers[@]}
   do
      echo $filenum
      query2="SELECT fRunStart from RunInfo WHERE fRunNumber="$runnumber" AND fFileNumber="$filenum
      starttime=`/usr/bin/mysql -u operator --host=fact01.fact.local --password=$password FactData -s -e "$query2" 2>> $logfile`
      query3="SELECT fRunStop from RunInfo WHERE fRunNumber="$runnumber" AND fFileNumber="$filenum
      stoptime=`/usr/bin/mysql -u operator --host=fact01.fact.local --password=$password FactData -s -e "$query3" 2>> $logfile`
      echo "start: "$starttime 
      echo "stop: "$stoptime 
      echo $trackingfile
      ftcopy $trackingfile'[Time>55889.1][col Ra]' - | ftstat - 

      exit
# notes: 
# ftcopy /loc_data/aux/2011/11/23/20111123.BIAS_CONTROL_NOMINAL.fits'[Time>55889.1][col Time]' - | ftstat - 
# ftcopy /loc_data/aux/2011/11/15/20111115.DRIVE_CONTROL_TRACKING_POSITION.fits'[Time>55880.8 && Time< 55880.9][col Ra;Time]' - | ftcopy -'[col Ra]' - | ftstat -
   done
   
done


