#ifndef EVIDENCE_H_SEEN
#define EVIDENCE_H_SEEN

#include <stdio.h>
#include <stdarg.h>
#include <errno.h>

#include "dis.hxx"
#include "dic.hxx"


// Declaration of item for history buffer (see DColl.cc)
struct EvidenceHistoryItem {
  int Seconds;
  double Value;
} __attribute__((__packed__));

// Class declation of Evidence server
class EvidenceServer: public DimExitHandler, public DimErrorHandler {

  private:
    char *ServerName;
	char *MsgBuffer;
	void *ConfigList;
	unsigned int ConfigNum;
    DimService *Status;

    static void SignalHandler(int);  // static needed for signal() function
	void errorHandler(int, int, char *);
	void exitHandler(int);
	
  public:
    EvidenceServer(const char *);
	~EvidenceServer();
	
	enum MsgType {INFO=0, WARN=1, ERROR=2, FATAL=3};

	void Msg(MsgType, const char *, ...);
	char* GetConfig(const char *);
	static char *ToString(DimInfo *);
	
    static bool ExitRequest;
};

#endif
