#ifndef MARS_MH3
#define MARS_MH3

#ifndef ROOT_TH1
#include <TH1.h>
#endif
#ifndef MARS_MH
#include "MH.h"
#endif

class TH1;
class TMethodCall;

class MH3 : public MH
{
protected:
    const Int_t fDimension;        // Number of dimensions of histogram

    TH1 *fHist;                    // Histogram to fill

    TString fDataMember[3];        // Data member which should be filled into the histogram x

    MParContainer *fObject[3];     // Object from which the data is filled
    TMethodCall   *fMethodCall[3]; // Method call to get the data from the object

    Double_t fScale[3];

    Bool_t GetValue(Int_t num, Double_t &v);
    Bool_t GetMethodCall(const MParList *plist, Int_t num);

public:
    MH3(const char *memberx);
    MH3(const char *memberx, const char *membery);
    MH3(const char *memberx, const char *membery, const char *memberz);
    ~MH3();

    void SetScaleX(Double_t scale) { fScale[0] = scale; }
    void SetScaleY(Double_t scale) { fScale[1] = scale; }
    void SetScaleZ(Double_t scale) { fScale[2] = scale; }

    Int_t GetDimension() const { return fDimension; }

    void SetName(const char *name);
    void SetTitle(const char *title);

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par);

    TH1 &GetHist() { return *fHist; }
    const TH1 &GetHist() const { return *fHist; }

    void Draw(Option_t *opt=NULL);
    TObject *DrawClone(Option_t *opt=NULL) const;

    ClassDef(MH3, 1) // Generalized 1/2/3D-histogram for Mars variables
};

#endif
