import matplotlib.pyplot as plt
import numpy as np
import numpy.ma as ma

def plotcam():
    chid, y,x,xe,ye,yh,xh,softid,hardid = np.loadtxt("map_dn.txt",unpack=True)
    fig = plt.figure()
    ax = fig.add_subplot(111, aspect='equal')
    H = (6,0,30./180.*3.1415926)
    ax.scatter(xe,ye,s=40,alpha=0.75,marker=H, linewidths=0.)
    plt.show()

def plotincam( data ):
    chid, y,x,xe,ye,yh,xh,softid,hardid = np.loadtxt("map_dn.txt",unpack=True)
    fig = plt.figure()
    ax = fig.add_subplot(111, aspect='equal')
    H = (6,0,30./180.*3.1415926)
    ax.scatter(xe,ye,s=40,alpha=0.75,marker=H, c=data)
    plt.show()

def plotmaskedcam( thr):
    chid, y,x,xe,ye,yh,xh,softid,hardid = np.loadtxt("map_dn.txt",unpack=True)
    data = np.random.rand(1440)
    mdata = ma.masked_greater(data, thr)
    fig = plt.figure()
    ax = fig.add_subplot(111, aspect='equal')
    H = (6,0,30./180.*3.1415926)
    
    a = ma.masked_where(mdata.mask == True, xe)
    b = ma.masked_where(mdata.mask == True, ye)
    
    xm = a.compressed()
    ym = b.compressed()
    dm = mdata.compressed()
    
    print xm
    print ym
    print dm
    ax.scatter(xe,ye,s=80,alpha=0.75,marker=H, c=data, edgecolors='none')
    ax.scatter( xm, ym ,s=80,alpha=1,marker=H,facecolors='none',linewidths=3)
    plt.show()


def randomcam():
    data = np.random.rand(1440)
    plotincam( data )


# uncomment what ever you like to test.

# plotcam()  #plot an empty cam .. 
# randomcam() # plot a cam filled with random data

 fun = np.linspace(0,1,1440)
 plotincam( fun )

#plotmaskedcam( 0.15 )

