#ifndef MARS_MDataMember
#define MARS_MDataMember

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  MDataMember                                                            //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MData
#include "MData.h"
#endif

class MDataMember : public MData
{
private:
    MParContainer *fObject;
    TMethodCall   *fCall;

public:
    MDataMember(const char *member) : fObject(NULL), fCall(NULL)
    {
        fName = member;
    }
    MDataMember(MParContainer *obj, TMethodCall *call);

    Double_t GetValue() const;
    Bool_t PreProcess(const MParList *plist);

    void Print(Option_t *opt = "") const;

    ClassDef(MDataMember, 0)	// List to combine several filters logically
};

#endif
