import matplotlib.pyplot as plt
import numpy as np
import numpy.ma as ma
import os, sys

class camplotter( object ):
    def __init__( self ):
        chid, y,x,ye,xe,yh,xh,softid,hardid = np.loadtxt("map_dn.txt",unpack=True)
        self.fig = plt.figure()
        self.xe = xe
        self.ye = ye
        self.H = (6,0,30./180.*3.1415926)
        
        coor2chid = {}
        chid2coor = []
        for i in range ( len(chid) ):
            coor2chid[ (x[i],y[i]) ] = chid[i]
            chid2coor.append( (x[i],y[i]) )
        
#        print coor2chid 
#        print chid2coor



#########################################################################
#########################################################################

if __name__ == '__main__':
    
    inputfname = 'nofile.npz'
    
    if (len(sys.argv) > 1):
        inputfname = sys.argv[1]
    else:
        print 'Usage ', sys.argv[0], 'input-file-path'
        exit (0)
        
    cplt = camplotter()
    
    # np.savez ( filename, amplitude=maxAmp, time=maxPos, integral=integ)
    npz = np.load( inputfname )
    print npz.files

    amp = npz['amplitude']
    int = npz['integral']
    tim = npz['time']
    
    files = []
    fig = plt.figure(figsize=(24,16))
#    plt.title('left amplitude ... right integral')
    ax1 = fig.add_subplot(231, aspect='equal')
    ax2 = fig.add_subplot(232, aspect='equal')
    ax3 = fig.add_subplot(233, aspect='equal')
    ax4 = fig.add_subplot(234)
    ax5 = fig.add_subplot(235)
    ax6 = fig.add_subplot(236)
    
    ax1.grid(True)
    ax2.grid(True)
    ax3.grid(True)
    ax4.grid(True)
    ax5.grid(True)
    ax6.grid(True)
    
    thr = 50
    hithr = 80
    lothr = 40
    print '------------ hiTHR=', hithr, 'loTHR=', lothr ,'-------------------'
    print '------------', len(amp[:,0]), '-------------------'

#    for i in range(len(data[:,0])):
    os.system("mkdir -p pngs")
    for i in range(50):
        
        mamp = ma.masked_less(amp[i,:], thr)
        mx = ma.masked_where(mamp.mask == True, cplt.xe)
        my = ma.masked_where(mamp.mask == True, cplt.ye)
        
        core = ma.masked_less(amp[i,:], hithr)
        edgecand = ma.masked_less(amp[i,:], lothr)
        #edgecand = ma.masked_where(core.mask == True, edgecand)
        
        mxc = ma.masked_where(core.mask == True, cplt.xe).compressed()
        myc = ma.masked_where(core.mask == True, cplt.ye).compressed()
        mxe = ma.masked_where(edgecand.mask == True, cplt.xe).compressed()
        mye = ma.masked_where(edgecand.mask == True, cplt.ye).compressed()
        
        
        ax1.cla()
        ax2.cla()
        ax3.cla()
        ax1.scatter(cplt.xe,cplt.ye,s=65,alpha=0.75,marker=cplt.H, c=amp[i,:], edgecolors='none', label='amp')
        #ax1.scatter(mx.compressed() , my.compressed() ,s=65,alpha=0.75,marker=cplt.H, facecolors='none', linewidths=3, edgecolors='r')
        if ( len(mxe) > 0 ):
            ax1.scatter(mxe , mye ,s=65,alpha=0.75,marker=cplt.H, facecolors='none', linewidths=2, edgecolors='r')
        if ( len(mxc) > 0 ):
            ax1.scatter(mxc , myc ,s=65,alpha=0.75,marker=cplt.H, facecolors='none', linewidths=3, edgecolors='k')
        ax1.axis([-22,22,-22,22])
        
        ax2.scatter(cplt.xe,cplt.ye,s=70,alpha=0.75,marker=cplt.H, c=int[i,:], edgecolors='none', label='inte')
        ax2.axis([-22,22,-22,22])
        ax3.scatter(cplt.xe,cplt.ye,s=70,alpha=0.75,marker=cplt.H, c=tim[i,:], edgecolors='none', label='time')
        ax3.axis([-22,22,-22,22])
        
        ax4.cla()
        ax4.hist(amp[i,:], 100, facecolor='r', alpha=0.75)
        ax4.set_yscale("log", nonposy='clip')

        ax5.cla()
        ax5.hist(int[i,:], 100, facecolor='g', alpha=0.75)
        ax5.set_yscale("log", nonposy='clip')

        ax6.cla()
        ax6.hist(tim[i,:], 100,facecolor='b', alpha=0.75)
        ax6.set_yscale("log", nonposy='clip')
        
        
        
        fname = 'pngs/_tmp%03d.png'%i
        print 'Saving frame', fname
        fig.savefig(fname)
        
        files.append(fname)

    # in order to make a movie using mencoder   -- uncomment the following two lines
    # 
    #print 'Making movie animation.mpg - this make take a while'
    #os.system("mencoder 'mf://pngs/_tmp*.png' -mf type=png:fps=2 -ovc lavc -lavcopts vcodec=wmv2 -oac copy -o animation.mpg")
    
    # in order to make an animated gif using ImageMagick   -- uncomment the following two lines
    #
    #print 'Making animated gif animation.gif - this make take a while'
    #os.system("convert -delay 33 -loop 0 pngs/_tmp*.png animation.gif")
    