/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  04/2002 <mailto:tbretz@uni-sw.gwdg.de>
!
!   Copyright: MAGIC Software Development, 2000-2002
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
//   MDataList
//   Chain, catenation ?
//
/////////////////////////////////////////////////////////////////////////////

#include "MDataMember.h"

#include <TMethodCall.h>

#include "MLog.h"
#include "MLogManip.h"

#include "MParList.h"

ClassImp(MDataMember);

MDataMember::MDataMember(MParContainer *obj, TMethodCall *call)
{
    fObject = obj;
    fCall   = call;
}

Double_t MDataMember::GetValue() const
{
    if (!fCall)
        return 0;

    switch (fCall->ReturnType())
    {
    case TMethodCall::kLong:
        Long_t l;
        fCall->Execute(fObject, l);
        return (Double_t)l;

    case TMethodCall::kDouble:
        Double_t v;
        fCall->Execute(fObject, v);
        return v;

    default:
        *fLog << err << "DataMember " << fName << " of ";
        *fLog << fObject->GetName() << " neither int nor float... abort." << endl;
        return 0;
    }
}

Bool_t MDataMember::PreProcess(const MParList *plist)
{
    TString cname(fName);
    TString mname(fName);

    const char *dot = strrchr(cname, '.');

    if (dot)
    {
        const int pos = dot-cname;

        cname.Remove(pos);
        mname.Remove(0, pos+1);
    }

    fObject = (MParContainer*)plist->FindObject(cname);
    if (!fObject)
    {
        *fLog << err << "Object '" << cname << "' not in parameter list... aborting." << endl;
        return kFALSE;
    }

    fCall = fObject->GetterMethod(mname);

    return fCall ? kTRUE : kFALSE;
}

void MDataMember::Print(Option_t *opt = "") const
{
    *fLog << fName << flush;
}

