#!/usr/bin/python
#
# Werner Lustermann
#
# ETH Zurich
# 
# sample1 of automatic generation and submission of scripts
#
import os
from optparse import OptionParser

parser = OptionParser()
parser.usage = """
python submit.py [options]
or
submit [options]"""

parser.description = """
Example script, generating a series of scripts for submission to a queing system
the existance of a script containing the class definition of an analysis job
is supposed. The constructor of this class is supposed to take 3 parameters

Note: I used optparse - old - I should have used argparse - to be changes soon
"""

parser.add_option('-f', '--file', action = 'store', dest='fname', 
	default = '', help = 'name of file containing run parameters' )
parser.add_option('-q', '--queue', action = 'store', dest='queue', 
	default = 'fact_short', help = 'specify queue: { fact_short, fact_middle, fact_long}' )
parser.add_option('-c', '--cmd', action = 'store', dest='cmd', 
	default = 'qsub', help = 'cmd: name of the queuing command' )
parser.add_option('-s', '--script', action = 'store', dest='script', 
	default = 'my_ana', help = 'script: name of the script file' )
parser.add_option('-j', '--job', action = 'store', dest='job', 
	default = 'ana1', help = 'job: name of the job (class) in the script file' )


(options, args) = parser.parse_args()

if len( options.fname ) == 0:
    para_list = [ [ 'f12_1', 'f12_2', 'f12_3' ],
		  [ 'f13_1', 'f13_2', 'f13_3' ], 
		  [ 'f14_1', 'f14_2', 'f14_3' ]
		  ]
else:
    print 'read para list from file: ', options.fname
    para_list = []

job_fname = options.script + '_' + options.job + '.py'
	
for run in para_list:
    """ loop over all runs
    
    - create the program text
    - save it to disk
    - submit the job

    """

    pl = ''
    for opt in run:
        pl += '\'' + opt + '\','
	#pl = pl[:-1] # remove the last comma
	
	cmd = 'ana = ' + options.job + '( ' + pl + ')' 
	
	# compose the text of the program script
	prg_text = """
#!/usr/bin/python
# program script generate by submit.py
#
# Werner Lustermann, ETH Zurch
#
from """ + options.script + ' import ' + options.job + '\n\n' + \
cmd + """
ana.run()
# end of script"""
	
# print 'program:'
# print prg_text
# print

# save the program to disk
file = open( job_fname, 'w' )
file.write( prg_text )
file.close()

# submit the program script
shell_cmd = 'qsub -S/usr/bin/python -V -q ' + options.queue + ' ', options.job
print 'shell_cmd: ', shell_cmd
os.system( 'python ' + job_fname )	
	
