#!/usr/bin/python
#
# Werner Lustermann
# ETH Zurich
#
from ROOT import TH1F
import pyfact

from hist import histogramList

class bslHistograms( histogramList ):

    def book( self ):

        # print 'bslHistograms::book'
        
        self.h1d( "hbsl_mean","Value of maximal probability",
                  400, -99.5, 100.5, 'max value (mV)', 'Entries / 0.5 mV')

        self.h1d("hplt_mean","Value of maximal probability",
            1440, -0.5, 1439.5, 'max value in mV', 'Entries / 0.5 mV')
    
        self.h1d("hbsl_rms","RMS in mV",
                 2000, -99.5, 100.5, 'RMS (mV)', 'Entries / 0.5 mV' )

        self.h1d( 'hplt_rms', 'Value of maximal probability',
                   1440, -0.5, 1439.5, 'pixel', 'RMS in mV' )



def H1d( name, title, Nbin, first, last, xtitle, ytitle ):

    h = TH1F( name, title, Nbin, first, last );
    h.GetXaxis().SetTitle( xtitle );
    h.GetYaxis().SetTitle( ytitle );

    return h


def BookBslSummaryHistos( list ):

    list.add( 'hbsl_mean', H1d( "histo_mean","Value of maximal probability",
                               400, -99.5, 100.5,
                               'max value (mV)', 'Entries / 0.5 mV') )

    h = H1d("hplt_mean","Value of maximal probability",
            1440, -0.5, 1439.5, 'max value in mV', 'Entries / 0.5 mV')
    list.add( 'hplt_mean', h )

    h = H1d("histo_rms","RMS in mV",2000,-99.5,100.5, 'RMS (mV)', 'Entries / 0.5 mV' )
    list.add( 'hbsl_rms', h )

    list.add( 'hplt_rms',
              H1d( 'hplt_rms', 'Value of maximal probability',
                   1440,-0.5,1439.5, 'pixel', 'RMS in mV' ) )
              

