#!/usr/bin/python
#
# Werner Lustermann
# ETH Zurich
#
import numpy as np

import pyfact_rename
from myhisto import *
from hist import *

import sys

year, month, day = 2011, 11, 24
year, month, day = str(year), str(month), str(day)
yyyymmdd = year + month + day
dfile = '023'
cfile = '012'

path = '/data03/fact-construction/raw/'
ext  = '.fits'
dfname = path + year + '/' + month + '/' + day + '/' + yyyymmdd + '_' + dfile + ext

calfname = path + year + '/' + month + '/' + day + '/' + yyyymmdd + '_' + cfile + '.drs' + ext

resFileName =  yyyymmdd + '_' + dfile + '_' + cfile 

print 'processing files:'
print 'data:    ', dfname
print 'drs-cal: ', calfname

rd = pyfact.rawdata( dfname, calfname )

# rd.ReadBaseline( 'histo.root', 'bls_sum/hplt_mean' )

rd.NEvents = 70
print 'processing N events ', rd.NEvents
step     = 500
nsteps   = rd.NEvents / step + 1
evranges = range(0, (nsteps+1) * step, step)

evranges[-1] = int( rd.NEvents )

bslMeanValues = np.zeros( ( nsteps, rd.NPIX) )

def loopEvents( first, last, hist):
    """
    LOOP over all events: Do what you want, here!
    """
    for ev in range( first, last ):
        if ev%100 == 0: print 'Event', ev
        
        rd.next()
        # rd.CorrectBaseline()
        hist.fillall( rd.acalData )
    

def loopPixel( npix, phist ):
    vmaxprob = np.zeros( npix )
    v_rms    = np.zeros( npix )

    for pix in range( npix ):
    
        hpix = phist.list[pix]
    
        vmaxprob[pix] = hpix.GetXaxis().GetBinCenter( hpix.GetMaximumBin() )
        bslSummaryHistos.dict['hbsl_mean'].Fill( vmaxprob[pix] )
        bslSummaryHistos.dict['hplt_mean'].SetBinContent(pix+1, vmaxprob[pix] )
        
        v_rms[pix] = hpix.GetRMS()
        bslSummaryHistos.dict['hbsl_rms'].Fill( v_rms[pix] )
        bslSummaryHistos.dict['hplt_rms'].SetBinContent( pix+1, v_rms[pix] );

    return vmaxprob

pixhist = hist_array( rd.NPIX, 400, -99.5, 100.5,
                      'bsl_pix', 'Pixel Baseline',
                      'sample value in mV', 'Entries / 0.5 mV' )  

for step in range( nsteps ):
    print step, 'processing events: ', evranges[step], 'to ', evranges[step+1]

    pixstephist = hist_array( rd.NPIX, 400, -99.5, 100.5,
                          'bsl_pix_step', 'Pixel Baseline',
                          'sample value in mV', 'Entries / 0.5 mV' )  
    
    loopEvents( evranges[step], evranges[step+1], pixstephist )
    pixhist.y[:,:] += pixstephist.y[:,:] 
    pixstephist.SetBinContent()

    bslSummaryHistos = bslHistograms( 'bsl_sum' )
    bslMeanValues[step,:] = loopPixel( rd.NPIX, pixstephist )
    print bslMeanValues
    
    fname = 'h'+ str( evranges[step] ) + '_to_'+ str( evranges[step+1] ) + '.root'
    SaveHistograms( [pixstephist, bslSummaryHistos], fname )

    del pixstephist
    del bslSummaryHistos

pixhist.SetBinContent()
bslSummaryHistos = bslHistograms( 'bsl_sum' )
loopPixel( rd.NPIX, pixhist )

fname = 'hbsl.root'
SaveHistograms( [pixhist, bslSummaryHistos], resFileName + '_bsl.root' )

np.savetxt( resFileName + '_bls.dat', bslMeanValues, fmt = '%8.3f' )
np.save( resFileName + '_bsl.npy', bslMeanValues )
