#!/usr/bin/python
#
# Werner Lustermann
# ETH Zurich
#
# plotter.py

import numpy as np
import matplotlib.pyplot as plt

class UniqueID(object):
    """ provide a unique identifier accross objects """
    
    def __init__(self, start_value=1):
        """ initialize the object """
        
        self.value = start_value
        
    def __call__(self):
        """ return the present id and compute the next one """
        
        value = self.value
        self.value += 1
        
        return(value)
        
def _test_UniqueID(start_value=1):
    
    fig_id = UniqueID(start_value)
    
    for i in range(10):
        print 'fig_id: ', fig_id()
        

class Plotter(object):
    """ simple x-y plot """
    def __init__(self, name, x, my_id, style = 'b', xlabel='x', ylabel='y'):
        """ initialize the object """
        
        self.name  = name
        self.fig_id = my_id()
        plt.figure(self.fig_id)
        self.line, = plt.plot(x, style)
        
        plt.title(name)
        plt.xlabel(xlabel)
        plt.ylabel(ylabel)
        plt.grid(True)
           
    def __call__(self, ydata):
        """ set ydata of plot """
        plt.figure(self.fig_id)
        plt.ylim( np.min(ydata), np.max(ydata) )
        self.line.set_ydata(ydata)
        plt.draw()
            
def _test():
    """ test of maintaining two independant plotter instances """
    
    plotter_id = UniqueID(1)
    plt.ion()
    
    x = np.linspace(0., 10.)
    plot1 = Plotter('plot1', x, plotter_id, 'r')
    print 'plot1.fig_id: ', plot1.fig_id
    plot2 = Plotter('plot2', x, plotter_id, 'g.')
    #print 'plot2.fig_id: ', plot2.fig_id
    
    plot1(np.sin(x) * 7.)
    plot2(x*x)
    
    raw_input('next')
    
    plot1(np.cos(x) * 3.)
    plot2(x)
    
    raw_input('next')
    
    
    
if __name__ == '__main__':
    """ test the class """
    
    #_test_UniqueID(0)
    
    _test()