#include "PixelMap.h"
#include <iostream>
#include <fstream>
#include <cstring>
#include <cstdlib>
#include <cctype>

PixelMap::PixelMap() {

    pixelmap.clear();
    ReadPixelMap(pixelmap, false);

}

PixelMap::~PixelMap() {

    for( std::map<const std::string, Pixel*>::iterator iter = pixelmap.begin(); iter != pixelmap.end(); ++iter ) {
	delete ((*iter).second);
    }

}

void PixelMap::ReadPixelMap(std::map<std::string, Pixel*>& pixelmap, bool verbose) {

    std::string filename("PixelMap.txt");
    std::ifstream infile(filename.c_str(), std::fstream::in);

    std::cout<<"Reading mapping file: "<<filename<<std::endl<<std::endl;

    if (!infile.good()) {
	std::cerr<<"ERROR in PixelMap::ReadPixelMap: File "<<filename<<" cannot be found."<<std::endl;
    }

    while (infile.good()) {
	
	char line[1024];

	infile.getline(line, 1024);

	if (line[0] == '#') {
	    if (verbose) {
		std::cout << "Ignoring comment: " << line << std::endl;
	    }
	}

	else {
	    
	    if (strlen(line)!=0) {
		
		char delim[] = ":";
		char *name = NULL; //unformated name before : tokens
		char name2[256] = ""; //formated name without whitespaces
		char *rest = NULL;
		
		name = strtok(line, delim);

		unsigned int count1 = 0; //count non-whitespace characters in name
		unsigned int count2 = 0; //count number of - in name

		for (unsigned int i = 0; i < strlen(name); i++) {

		    if ( !(isspace(name[i])) ) {

			name2[count1] = name[i];
			count1+=1;

			if ( (name[i] == 45) ) {
			    count2+=1;
			}

		    }

		}

		if (verbose) {
		    std::cout << "Formated pixel name: " << name2 << std::endl;
		}

		if( (count1 > 4) && (count1 < 7) && (count2 == 2) ) {

		    rest = strtok(NULL, delim);
		
		    if(rest != NULL) {
			
			unsigned int DRSboard = (unsigned int)strtod(rest, &rest);					    
			unsigned int DRSchip = (unsigned int)strtod(rest, &rest);	    
			unsigned int DRSchannel = (unsigned int)strtod(rest, &rest);
			unsigned int HVboard = (unsigned int)strtod(rest, &rest);
			unsigned int HVchain = (unsigned int)strtod(rest, &rest);
			unsigned int HVchannel = (unsigned int)strtod(rest, &rest);

			pixelmap[name2] = new Pixel(DRSboard, DRSchip, DRSchannel,
						    HVboard, HVchain, HVchannel);

		    }

		}

		else {

		    std::cout << "ERROR in PixelMap::ReadPixelMap: Wrong pixel name: " << name2 << " -> pixel not initialized" << std::endl;

		}

	    } 

	    else {

		if(verbose){

		    std::cout << "Skipping empty line" << std::endl;

		}

	    }

	}
	
    }

    if(verbose){
	for( std::map<const std::string, Pixel*>::iterator iter = pixelmap.begin(); iter != pixelmap.end(); ++iter ) {
	    std::cout << std::endl << (*iter).first << std::endl << "-----------" << std::endl << *((*iter).second);
	}
    }

    std::cout << pixelmap.size() << " pixels found" << std::endl << std::endl;

    infile.close();
								
}

void PixelMap::Print() {

    std::cout << "Printing entries of pixelmap:" << std::endl << std::endl;

    for( std::map<const std::string, Pixel*>::iterator iter = pixelmap.begin(); iter != pixelmap.end(); ++iter ) {
	std::cout << (*iter).first << std::endl << "------------" << std::endl << *((*iter).second) << std::endl;
    }
    
}

std::string PixelMap::DRS_to_Pixel(unsigned int DRSboard, unsigned int DRSchip, unsigned int DRSchannel) {

    std::string pixelname = "";

    for( std::map<const std::string, Pixel*>::iterator iter = pixelmap.begin(); iter != pixelmap.end(); ++iter ) {

	if( ( ((*iter).second)->GetPixelDRSboard() == DRSboard ) &&
	    ( ((*iter).second)->GetPixelDRSchip() == DRSchip ) &&
	    ( ((*iter).second)->GetPixelDRSchannel() == DRSchannel ) ) {

	    pixelname = (*iter).first;

	}

    }

    if(pixelname == ""){

	std::cout << "ERROR in PixelMap::DRS_to_Pixel: No pixel with DRS board, chip, channel = "
		  << DRSboard << ", "
		  << DRSchip << ", "
		  << DRSchannel << " found in pixelmap" << std::endl;
	
    }

    return pixelname;

}

std::string PixelMap::HV_to_Pixel(unsigned int HVboard, unsigned int HVchain, unsigned int HVchannel) {

    std::string pixelname = "";

    for( std::map<const std::string, Pixel*>::iterator iter = pixelmap.begin(); iter != pixelmap.end(); ++iter ) {

	if( ( ((*iter).second)->GetPixelHVboard() == HVboard ) &&
	    ( ((*iter).second)->GetPixelHVchain() == HVchain ) &&
	    ( ((*iter).second)->GetPixelHVchannel() == HVchannel ) ) {

	    pixelname = (*iter).first;

	}

    }

    if(pixelname == ""){

	std::cout << "ERROR in PixelMap::HV_to_Pixel: No pixel with HV board, chain, channel = "
		  << HVboard << ", "
		  << HVchain << ", "
		  << HVchannel << " found in pixelmap" << std::endl;
	
    }

    return pixelname;

}

unsigned int PixelMap::Pixel_to_DRSboard(std::string pixelname) {

    unsigned int DRSboard = 999999999;

    if(pixelmap[pixelname] != NULL) {

	DRSboard = pixelmap[pixelname]->GetPixelDRSboard();

    }

    else {

	std::cout << "ERROR in PixelMap::Pixel_to_DRSboard: No pixel with name = "
		  << pixelname << " found in pixelmap" << std::endl;

    }

    return DRSboard;

}

unsigned int PixelMap::Pixel_to_DRSchip(std::string pixelname) {

    unsigned int DRSchip = 999999999;

    if(pixelmap[pixelname] != NULL) {

	DRSchip = pixelmap[pixelname]->GetPixelDRSchip();

    }

    else {

	std::cout << "ERROR in PixelMap::Pixel_to_DRSchip: No pixel with name = "
		  << pixelname << " found in pixelmap" << std::endl;

    }

    return DRSchip;

}

unsigned int PixelMap::Pixel_to_DRSchannel(std::string pixelname) {

    unsigned int DRSchannel = 999999999;

    if(pixelmap[pixelname] != NULL) {

	DRSchannel = pixelmap[pixelname]->GetPixelDRSchannel();

    }

    else {

	std::cout << "ERROR in PixelMap::Pixel_to_DRSchannel: No pixel with name = "
		  << pixelname << " found in pixelmap" << std::endl;

    }

    return DRSchannel;

}

unsigned int PixelMap::Pixel_to_HVboard(std::string pixelname) {

    unsigned int HVboard = 999999999;

    if(pixelmap[pixelname] != NULL) {

	HVboard = pixelmap[pixelname]->GetPixelHVboard();

    }

    else {

	std::cout << "ERROR in PixelMap::Pixel_to_HVboard: No pixel with name = "
		  << pixelname << " found in pixelmap" << std::endl;

    }

    return HVboard;

}

unsigned int PixelMap::Pixel_to_HVchain(std::string pixelname) {

    unsigned int HVchain = 999999999;

    if(pixelmap[pixelname] != NULL) {

	HVchain = pixelmap[pixelname]->GetPixelHVchain();

    }

    else {

	std::cout << "ERROR in PixelMap::Pixel_to_HVchain: No pixel with name = "
		  << pixelname << " found in pixelmap" << std::endl;

    }

    return HVchain;

}

unsigned int PixelMap::Pixel_to_HVchannel(std::string pixelname) {

    unsigned int HVchannel = 999999999;

    if(pixelmap[pixelname] != NULL) {

	HVchannel = pixelmap[pixelname]->GetPixelHVchannel();

    }

    else {

	std::cout << "ERROR in PixelMap::Pixel_to_HVchannel: No pixel with name = "
		  << pixelname << " found in pixelmap" << std::endl;

    }

    return HVchannel;

}
