#!/usr/bin/python
#
# Dominik Neise
#
from pyfact_rename import *
from fir_filter import *
from extractor import *
from drs_spikes import *
from plotters import *
import os.path
import matplotlib.pyplot as plt
import numpy as np
import sys

data_file_name = '/media/daten_platte/FACT/data/20120305_022.fits.gz'
calib_file_name = '/media/daten_platte/FACT/data/20120305_005.drs.fits.gz'
run = RawData(data_file_name, calib_file_name)
despike = DRSSpikes()

plot_all = Plotter('-to-be-changed-', style ='.:', ylabel='mV', xlabel='slices')
plot = Plotter('-to-be-changed-', style ='.:', ylabel='FTU DAC counts', xlabel='slices')

# according to Ulf Roeser, the clipping cable is about 5ns long and damps reflection by about 0.9
clipping = CFD( length=20, ratio=0.9)



# add up 9 pixels
for data, scell, tt in run:
    data = despike(data)
    print 'this script is just plotting ... no further output or analysis is done'
    print 'to end it ... Ctrl-C and then hit <Enter> so python'
    for begin in range(0,data.shape[0],9):
        print 'plotting pixels:', begin, 'to', begin+8
        
        patch_sig = np.sum(data[begin:begin+9,:],axis=0)
        
        # scaling signal as it should be in front of the comparator
        # factors are according to poster of Olli
        # EPS_HEP-Electronics.pdf ... I did not check the numbers again
        # factor between DRS and U1A
        patch_sig /=-2
        # from U1A to comparator
        patch_sig *= 1./5.4 * 4.5 * -1. * 0.5 * 4.5 * 0.9

        # in order to understand the FTU treschold a little better
        # I scale the voltages to FTU DAC counts: 12bits @ 2.5Volts
        patch_sig *= 1./2500 * 2**12
        #now clipping is applied.
        pre_clip = patch_sig
        patch_sig = -1*clipping(patch_sig)
        plot.name = 'sum of pixels:' + str(begin) +'..' + str(begin+8) + ' as seen on FTU'
        plot ( (pre_clip,patch_sig) , ('pre_clip','comparator in') )
        plt.legend()
        
        
        
        # plotting
        labels=[]
        for i in range(9):
            labels.append('pix_'+str(i))
        #labels.append('patch')
        #to_plot = np.vstack( (data[begin:begin+9,:],patch_sig) )
        to_plot = data[begin:begin+9,:]
        plot_all.name = 'pixels:' + str(begin) +'..' + str(begin+8)
        plot_all( to_plot , labels)
        plt.legend()
        
        user_input = raw_input("'q' for quit, anything else goes on")
        if user_input.find('q') != -1:
            sys.exit(0)
    
