#!/usr/bin/python
#
# Dominik Neise
#
from pyfact_rename import *
import os.path
import matplotlib.pyplot as plt
import numpy as np
from fir_filter import *
from extractor import *
from drs_spikes import *
from plotters import *
import sys
confirm_next_step = True # this is for user interaction


data_file_name = '/media/daten_platte/FACT/data/20120305_022.fits.gz'
calib_file_name = '/media/daten_platte/FACT/data/20120305_005.drs.fits.gz'
run = RawData(data_file_name, calib_file_name)
despike = DRSSpikes()

# according to Ulf Roeser, the clipping cable is about 5ns long and damps reflection by about 0.9
clipping = CFD( length=20, ratio=0.9)

thresholds = range(100, 1001, 20)
plotter =Plotter('time_over_thr', x=thresholds, xlabel='FTU threshold [DAC units]', ylabel='Board time over threshold[slices]')

# addiere immer 9 pixel
for data, scell, tt in run:
    data = despike(data)
    event_id = run.event_id.value
    #print 'event# : ' , run.event_id.value
#    print 'data.shape', data.shape
    #prepare placeholder for the input of the comparator
    ftu_comp_in = np.empty( (data.shape[0]/9, data.shape[1]-20), dtype='float64' )
#    print 'ftu_comp_in.shape', ftu_comp_in.shape
    
    #prepare space for the compartor output for all thresholds under test
    ftu_comp_out_shape = (len(thresholds), ftu_comp_in.shape[0]/4 , ftu_comp_in.shape[1])
    ftu_comp_out = np.empty( ftu_comp_out_shape, dtype=bool)
#    print 'ftu_comp_out.shape', ftu_comp_out.shape
    
    time_over_thr = np.empty( (len(thresholds), ftu_comp_in.shape[0]/4),dtype=int)
#    print 'time_over_thr.shape', time_over_thr.shape
    
    
    
    for begin in range(0,data.shape[0],9):
        patch_sig = np.sum(data[begin:begin+9,10:-10],axis=0)
            
        # scaling signal as it should be in front of the comparator
        # factors are according to poster of Olli
        # EPS_HEP-Electronics.pdf ... I did not check the numbers again
        # factor between DRS and U1A
        patch_sig /=-2
        # from U1A to comparator
        patch_sig *= 1./5.4 * 4.5 * -1. * 0.5 * 4.5 * 0.9

        # in order to understand the FTU treschold a little better
        # I scale the voltages to FTU DAC counts: 12bits @ 2.5Volts
        patch_sig *= 1./2500 * 2**12
        #now clipping is applied.
        patch_sig = -1*clipping(patch_sig)
        
        #store patch signal
        ftu_comp_in[begin/9] = patch_sig
        
#    print 'checking for thresholds'
    
    
    for thr_id,thr in enumerate(thresholds):
        
        for board_id in range(len(ftu_comp_in)/4):
            patch_comp_out = np.zeros( ftu_comp_out.shape[2], dtype=bool )
            for patch_id in range(4):
                # OR the 4 patch outs together
                patch_comp_out += ftu_comp_in[4*board_id+patch_id] > thr
#            print 'thr_id', thr_id
#            print 'board_id', board_id
#            print 'ftu_comp_out[thr_id][board_id].shape', ftu_comp_out[thr_id][board_id].shape
#            print 'patch_comp_out.shape', patch_comp_out.shape
            ftu_comp_out[thr_id][board_id]=patch_comp_out
            time_over_thr[thr_id][board_id]=patch_comp_out.sum()

    # really bad coding here:
    # the path is hardcoded, 
    # and if the path does no exist, it is not created automatically
    # both is very bad
    #
    # anyway if you want to save the plots to file ... just comment this in
    # and give some nice filename ... 
    #plotter.fname='./20120305_022/_'+str(event_id) + '.png'

    plotter.name='time over thr, for all boards | Evt ID = ' + str(event_id)
    plotter(np.transpose(time_over_thr))
    
    print 'event# : ' , event_id,
    
    if confirm_next_step:
        user_input = raw_input("'q'-quit, 'r'-run, anything else goes one step")
        if user_input.find('q') != -1:
            sys.exit(0)
        elif user_input.find('r') != -1:
            confirm_next_step = False

