#ifndef MARS_MDataChain
#define MARS_MDataChain

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  MDataList                                                              //
//                                                                         //
//  List of several filters                                                //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MData
#include "MData.h"
#endif

class MDataChain : public MData
{
private:
    MData *fMember; // Filter

    Int_t IsAlNum(TString txt);

    MData *ParseString(TString txt, Int_t level);

public:
    MDataChain(const char *text, const char *name=NULL, const char *title=NULL);
    ~MDataChain();

    Double_t GetValue() const;
    Bool_t PreProcess(const MParList *plist);

    Bool_t IsValid() const { return fMember ? kTRUE : kFALSE; }

    void Print(Option_t *opt = "") const;

    ClassDef(MDataChain, 0) // A Filter for cuts in any data member
};

#endif
