#!/bin/bash

# this script has been written to run on La Palma on the machine data
#   i.e. paths are only working on this machine

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting "$0

logfile=$runlogpath"/RsyncAuxToISDC-"$datetime".log"
date >> $logfile

# get last 3 nights
dates=( `date +%Y/%m/%d --date="-12hour"` `date +%Y/%m/%d --date="-36hour"` `date +%Y/%m/%d --date="-60hour"` )

# do rsync for rawfiles of these dates
for date in ${dates[@]}
do 
   echo "" >> $logfile 2>&1
   echo $date >> $logfile 2>&1
   # auxiliary data directories
   auxdirlp=/loc_data/aux/./$date/ 
   auxdirisdc=/scratch/from_lapalma/aux
   
   printprocesslog "INFO processing files in "$auxdirlp >> $logfile 2>&1
   echo `date`": processing files in "$auxdirlp >> $logfile 2>&1
   
   # get current hour
   hour=`date +%k`
   # define bwlimit for rsync depending on the time: from 19-7h reduced bwlimit for rsync
   if [ $hour -le 14 ] || [ $hour -ge 13 ]
   then
      # use once a day the -c option
      #   normally files are compared by size and time
      #   but for the daily files the size doesn't change when TSTOP is added
      #   due to the one hour time difference it could happen that rsync
      #     doesn't update the file when only checking time and size
      # run with this option after lunch (LP time)
      option="-c"
      printprocesslog "INFO rsync data with option "$option >> $logfile 2>&1
      echo "rsync data with option "$option >> $logfile 2>&1
   else 
      # no extra option
      printprocesslog "INFO rsync data without extra option" >> $logfile 2>&1
      echo "rsync data without extra option" >> $logfile 2>&1
   fi
   
   #rsync from daq to data
   #if ! /usr/bin/rsync -avxHPu $bwlimit $auxdirdaq $auxdirdata >> $logfile 2>&1 # in case of adding checksum, only update files with rsync
   if ! rsync -rltDvR --stats fact@161.72.93.131:$auxdirlp $auxdirisdc >> $logfile 2>&1
   then
      printprocesslog "WARN problem rsyncing auxiliary data for "$date" from La Palma to ISDC"
      echo `date`": problem rsyncing auxiliary data for "$date" from La Palma to ISDC" >> $logfile 2>&1
      echo `date`": problem rsyncing auxiliary data for "$date" from La Palma to ISDC"
   fi
done

