#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"
program=RsyncRawToWue
step=RawFileAvailWue

set -C

logfile=$runlogpath"/RsyncRawToWue-"$datetime".log"
date >> $logfile

# check if script is already running
lockfile=$lockpath/lock-$program.txt
checklock 

# get todo list
gettodo 


for (( s=0 ; s < $num ; s++ ))
do
   night=${primaries[$s+$s]}
   runid=${primaries[$s+$s+1]}
   nightpath=`echo $night | cut -c 1-4`"/"`echo $night | cut -c 5-6`"/"`echo $night | cut -c 7-8`
   
   setstatus "start" 

   rawfileisdc="/scratch/from_lapalma/raw/./"$nightpath"/"$night"_"`printf %03d $runid`".fits.gz"
   rawdirwue="/fact/raw/"

   printprocesslog "INFO rsync rawfile "$rawfileisdc" to Wue "$rawdirwue
   #rsync -rltDvR --partial --stats --password-file=/home_nfs/isdc/fact_opr/rsync.pwd factdata@161.72.93.131::$rawfilelp $rawdirisdc >> $logfile 2>&1
   rsync -avxR --no-p --stats $rawfileisdc operator@coma.astro.uni-wuerzburg.de:$rawdirwue >> $logfile 2>&1
   check1=$?

   case $check1 in
      0)   printprocesslog "INFO rawfile "$rawfileisdc" transferred successfully to Wue."
           ;;
      *)   printprocesslog "WARN "$rawfileisdc" could not be transferred to Wue."
           check=$check1
           ;;
   esac
   
   query="SELECT fHasDrsFile from RunInfo WHERE fNight="$night" AND fRunID="$runid
   numdrs=`sendquery`
   if [ $numdrs -gt 0 ]
   then 
      drsfileisdc=$rawdirisdc$nightpath"/"$night"_"`printf %03d $runid`".drs.fits.gz"
      printprocesslog "INFO rsync rawfile "$drsfileisdc" to Wue "$rawdirwue
      rsync -avxR --no-p --stats $rawfileisdc operator@coma.astro.uni-wuerzburg.de:$rawdirwue >> $logfile 2>&1
      check1=$?

      case $check1 in
         0)   printprocesslog "INFO rawfile "$drsfileisdc" transferred successfully to Wue."
              ;;
         *)   printprocesslog "WARN "$drsfileisdc" could not be transferred to Wue."
              check=$check1
              ;;
      esac
   fi

   setstatus "stop" 
done

finish 

