#!/usr/bin/python -i
#
# Dominik Neise
#
# cleaning a small step towards the truth
from pyfact_rename import *
import os.path
import matplotlib.pyplot as plt
import numpy as np
from fir_filter import *
from extractor import *
from drs_spikes import *
from plotters import *
import time as t
from cleaners import AmplitudeCleaner
confirm_next_step = False# this is for user interaction

data_file_name = '/media/daten_platte/FACT/data/20120229_144.fits.gz'
calib_file_name = '/media/daten_platte/FACT/data/20120229_132.drs.fits.gz'
if not os.path.isfile(data_file_name):
    print 'not able to find file:', data_file_name
    sys.exit(-1)
if not os.path.isfile(calib_file_name ):
    print 'not able to find file:', calib_file_name 
    sys.exit(-1)

run = RawData(data_file_name, calib_file_name)
despike = DRSSpikes()
smooth = SlidingAverage(8)
extract = GlobalMaxFinder(40,200)
cleaner = AmplitudeCleaner(45,18)

#plotA = CamPlotter('amplitudes')
#plotT = CamPlotter('times')
#plotCA = CamPlotter('cleaned amplitudes')

#plotArea = HistPlotter('area', 1440, (0,1440) )
#plotSize = HistPlotter('size', 1000, (0,10000) )


areas = []
sizes = []
for data,startcell,tt in run:
    # trigger type 4 means 'physics event'
    if tt==4:
        data = despike(data)
        data = smooth(data)
        amplitude, time_of_max = extract(data)
        clean_mask = cleaner(amplitude)
        #plotA.name='amplitudes EvtID:' + str(run.event_id.value) + ' TT:' + str(tt)
        #plotA(amplitude)
        #plotT(time_of_max)
        #plotCA(data=amplitude, mask=clean_mask)
        
        survivors = np.where( clean_mask)[0]
        size = 0
        for pixel in survivors:
            size += amplitude[pixel]
        
        if len(survivors) > 0:
            areas.append( len(survivors) )
            sizes.append( size )
        
        
        #plotArea(areas, 'areas of ' + str(run.event_id.value) + 'events')
        #plotSize(sizes, 'sizes of ' + str(run.event_id.value) + 'events')
        
        if confirm_next_step:
            user_input = raw_input("'q'-quit, 'r'-run, anything else goes one step")
            number=None
            try:
                number=int(user_input)
            except:
                number=None
            if user_input.find('q') != -1:
                sys.exit(0)
            elif user_input.find('r') != -1:
                confirm_next_step = False
            elif number!=None:
                run += number


plt.ion()
myfig = plt.figure()
myn = myfig.number
logsize = np.log10(np.array(sizes))
areas = np.array(areas)

plt.figure(myn)
plt.title('area vs. log10(size) of '+ str(run.event_id.value) + 'events')
plt.xlabel('log10(size/1mV)')
plt.ylabel('area [#pixel]')
plt.plot( logsize,areas, '.')
