#!/usr/bin/python
#
# Werner Lustermann
# ETH Zurich
#
import numpy as np
from pyfact_rename import RawData
from plotter import Plotter
from drs_spikes import DRSSpikes

import matplotlib.pyplot as plt

def spike_ana(candidates, singles, doubles, data, ind):
    """ call back function for DRSSpikes class """
    
    #print 'spike_ana - callback'
    print len(candidates), len(singles), len(doubles)

data_file_name = '/data00/fact-construction/raw/2011/11/24/20111124_111.fits.gz'
calib_file_name = '/data00/fact-construction/raw/2011/11/24/20111124_111.drs.fits.gz'
run = RawData( data_file_name, calib_file_name )

x = np.linspace(0., run.nroi, run.nroi)

plt.ion() # turn interactive mode on (plots are done immediately)

remove_spikes = DRSSpikes(7., user_action=spike_ana, debug=False)
raw_data_plot = Plotter('raw_data', x, 'g.', xlabel='slice in logical pipeline', 
                        ylabel='amplitude in mV')
rem_spikes_plot = Plotter('rem_spikes', x, 'r.', xlabel='slice in logical pipeline', 
                          ylabel='amplitude in mV')
 
ch = 0

inp = ''
data, scell, tt = run.next()
#print data[ch,0:10]
raw_data_plot(data[ch,:])
fdata = remove_spikes(data)
rem_spikes_plot(fdata[ch,:])

while ( inp != 'q' ):

    inp = raw_input('[n|p|q]: ')

    if inp == 'n':
        ch = (ch + 1)%1440
    elif inp == 'p':
        ch = (ch + 1)%1440
        print ch
    elif inp == 'q':
        pass
    else:
        data, scell, tt = run.next()
    
    #print data[ch, 0:10]
    raw_data_plot(data[ch,:])
    fdata = remove_spikes(data)
    rem_spikes_plot(fdata[ch,:])

