#!/usr/bin/python -i
#
# Dominik Neise
#
# copy of the /tools/cleaning/avea_vs_size.py script which was originally meant
# as an example for the AmplitudeCleaner.
#
# This script is an example how one can use the python dict, for 
# book keeping.
# Note, this script is not yet runnable, since one needs to change
# quite some things in the classes...
# this is just meant to be entertaining

from pyfact_rename import *
import os.path
import matplotlib.pyplot as plt
import numpy as np
from fir_filter import *
from extractor import *
from drs_spikes import *
from plotters import *
import time as t
from cleaners import AmplitudeCleaner
confirm_next_step = False# this is for user interaction

import sys
import pickle

# this little can will hold 
# * all the settings, 
# * all results and intermediate results
# * as well as this script itself
# and then it will be written, to an output file
can = {}                # the FACT can 
can['settings'] = {}    # a subspace for holdind all settings
can['results'] = {}     # a subspace for holding all results... or similar stuff
can['logbook'] = []     # a list of statements ... human readable logbook
can['src'] = []         # this script and other sources

# store this scipt in the list of sources.
can['src'].append( open(sys.argv[0], 'r').read() )

# declare filenames to work with:
can['setting']['data_file_names'] = ['/media/daten_platte/FACT/data/20120229_144.fits.gz']
can['setting']['calib_file_names'] = ['/media/daten_platte/FACT/data/20120229_132.drs.fits.gz']
# we even tell the can, where we are going to store it
can['setting']['outfile_name'] = ['./can.pkl']

# FileChecker checks if all files exist, and appends this action to the logbook
# if one File does not exist, it will cause this script to end. (...well ... maybe)
FileChecker(can)

# put the settings for all the extractors and similar data processors 
# into the settings
can['settings']['SlidingAverage'] = [8]
can['settings']['DRSSpikes'] = []
can['settings']['GlobalMaxFinder'] = [40,200]
can['settings']['AmplitudeCleaner'] = [45,18,'return_bool_mask=False']
# then call the __init__s of the processors and give them the can...
# they will see if they can find their own init parameters ... if not they take 
# the default
# in addition, they will add some lines to the logbook telling the reader
# that they were created, and what parameters they found/used.
event   = RawDataFeeder(can)
despike = DRSSpikes(can)
smooth  = SlidingAverage(can)
extract = GlobalMaxFinder(can)
cleaner = AmplitudeCleaner(can)

# prepare some space in the can, for the results of this script
can['results']['areas'] = []
can['results']['sizes'] = []
# and make some shortcuts
areas = can['results']['areas']
sizes = can['results']['sizes']

# this loop will loop over all events, out of all data files in the can,
# so the analysis loop doesn't even know, there are more files involved.
# of course in the logbook the opening and closing will be stored
for data,startcell,tt in event:
    if tt==4:
        data = despike(data)
        data = smooth(data)
        amplitude, time_of_max = extract(data)
        survivors = cleaner(amplitude)

        size = 0
        for pixel in survivors:
            size += amplitude[pixel]
        
        if len(survivors) > 0:
            areas.append( len(survivors) )
            sizes.append( size )
        # we suddenly realize, that we would like to store
        # the event IDs of events, which are have no survivors
        # we should scroll up ... before the loop and declare an empty list
        # like: can['results']['no_survivor_ids'] = []
        # but imagine we are writing a function, which is beeing called inside the loop
        # and this function has no possibility to declare that ...
        # well then this function can still put new things inside the can!
        else:
            if 'no_survivor_ids' not in can['results']:
                can['results']['no_survivor_ids'] = [event.event_id.value]
            else:
                can['results']['no_survivor_ids'].append(event.event_id.value)
        
        if confirm_next_step:
            user_input = raw_input("'q'-quit, 'r'-run, anything else goes one step")
            number=None
            try:
                number=int(user_input)
            except:
                number=None
            if user_input.find('q') != -1:
                sys.exit(0)
            elif user_input.find('r') != -1:
                confirm_next_step = False
            elif number!=None:
                run += number

# Now our analysis is done and we save the can
output = open(can['settings']['outfile_name'], 'wb')
pickle.dump(can, output)
output.close()