#!/usr/bin/python -tt
#
# Dominik Neise
# TU Dortmund
#
from coor import Coordinator
from euclid import Vector2

class SimpleArea(object):
    """ Calculate Hillas Area in simple way.
        Sum up the number of pixels, which survived the cleaning.
        The unit is [Number of Pixel]
    """
    def __init__(self):
        # I don't know, if classes, which need no initialization
        # do still need an empty __init__ func....
        pass

    def __call__(self, survivors):
        return len(survivors)

class SimpleSize(object):
    """ Calculate Hillas Size in a very simple way
        Sum up the 'amplitude'-like value, for each survivor
    """
    def __init__(self):
        # I don't know, if classes, which need no initialization
        # do still need an empty __init__ func....
        pass

    def __call__(self, survivors, amplitude):
        size = 0
        for pixel in survivors:
            size += amplitude[pixel]
        return size

class HillasParameter(object):
    """ Calculate Hillas Parameters
        http://magic.mppmu.mpg.de/publications/theses/TBretz.pdf   p.42
        
    """
    def __init__(self):
        self.coordinator = Coordinator()
        self.chid2coor = self.coordinator.chid2vec
        pass

    def __call__(self, survivors, amplitude):
        self.survivors = survivors
        self.amplitude = amplitude
        
        self._CalculateSize()
        self._CalculateCOG()
        
        
    def _CalculateSize(self):
        # shortcuts
        survivors = self.survivors
        amplitude = self.amplitude
        size = 0
        for pixel in survivors:
            size += amplitude[pixel]
            
        self.size = size
        return size
    
    def _CalculateCOG(self):
        # shortcuts
        survivors = self.survivors
        amplitude = self.amplitude
        chid2coor = self.chid2coor
        
        
        cog = Vector2( 0, 0)
        for chid in survivors:
            cog += chid2coor[chid] * amplitude[chid]
        cog /= self.size
        self.cog = cog
        return cog
    def _CaluculateM(self):
        """ M is a matrix I didn't understand yet.
            Maybe some kind of covariance matrix...
        """
        
if __name__ == '__main__':
    """ no tests yet """
    print 'no test implemented yet'