#!/usr/bin/python -tt
#
# Dominik Neise
# TU Dortmund
#
# example for storing numpy arrays containing FACT analysis results
# to file

#import this at first, please
from pyfact import RawData

import os.path
import numpy as np

from drs_spikes import DRSSpikes
from fir_filter import SlidingAverage
from extractor  import GlobalMaxFinder
from cleaners   import AmplitudeCleaner

##############################################################################
confirm_next_step = False# this is for user interaction

data_file_name = '/media/daten_platte/FACT/data/20120229_144.fits.gz'
if not os.path.isfile(data_file_name):
    print 'not able to find file:', data_file_name
    sys.exit(-1)
calib_file_name = '/media/daten_platte/FACT/data/20120229_132.drs.fits.gz'
if not os.path.isfile(calib_file_name ):
    print 'not able to find file:', calib_file_name 
    sys.exit(-1)

run = RawData(data_file_name, calib_file_name)
despike = DRSSpikes()
smooth = SlidingAverage(8)
extract = GlobalMaxFinder(40,200)
cleaner = AmplitudeCleaner(45, 18)

areas = []
sizes = []
for data,startcell,tt in run:
    # trigger type 4 means 'physics event'
    if tt==4:
        data = despike(data)
        data = smooth(data)
        amplitude, time_of_max = extract(data)
        survivors = cleaner(amplitude, return_bool_mask=False)

        # this is not python like, should be done in a single line
        # adding up the amplitude of all survivors
        size = 0
        for pixel in survivors:
            size += amplitude[pixel]
        
        area = len(survivors)
        
        if area > 0:
            areas.append( area )
            sizes.append( size )
        
        # This is for ---------- USER INTERACTION -------------------------
        if confirm_next_step:
            user_input = raw_input("'q'-quit, 'r'-run, anything else goes one step")
            number=None
            try:
                number=int(user_input)
            except:
                number=None
            if user_input.find('q') != -1:
                sys.exit(0)
            elif user_input.find('r') != -1:
                confirm_next_step = False
            elif number!=None:
                run += number
        # ---------------END OF USER INTERACTION -------------------------

outfname = raw_input("please enter name for outputfile")
np.savez(outfname, Area=areas, Size=sizes)
