#!/usr/bin/python -tt
#
# Example
#    * looping over RawData class object
# 

from pyfact   import RawData
from plotters import Plotter
from plotters import CamPlotter

from drs_spikes import DRSSpikes
from fir_filter import SlidingAverage
from extractor import GlobalMaxFinder
from cleaners import AmplitudeCleaner
from image_extractors import HillasParameter
from image_extractors import SimpleArea
from image_extractors import SimpleSize
import sys

data_filename = 'data/20120223_210.fits.gz'
calib_filename = 'data/20120223_206.drs.fits.gz'

run = RawData(data_filename, calib_filename, return_dict = True)
despike = DRSSpikes()
sa = SlidingAverage(8)
gmf = GlobalMaxFinder(30,230)
clean = AmplitudeCleaner(45,18)
clean.return_bool_mask = False
hillas = HillasParameter()

p = CamPlotter('cleaned')
#p2 = CamPlotter('not')


for event in run:
    if event['trigger_type'].value == 4:
    #if True:
        print event['event_id']
        data = event['acal_data']
        unspiked_data = despike(data)
        data = sa(data)
        amp, time = gmf(data)
        survivors, num_islands = clean(amp)
        #if num_islands == 1 and len(survivors) < 10:
        if True:
            print 'num_islands', num_islands
            print 'calling HillasParameter'
            hillas(survivors, amp)
            
            
            p ( amp, survivors )
            #p2 (amp)
            
            #sys.exit(0)
            
            answer = raw_input('hit <Enter> to go on .... hit "q" to quit')
            if 'q' in answer:
                break
print 'good bye'