#!/usr/bin/python -i

# Please read first:
#   * readme.1st and
#   * area_vs_hist_with_can.py
#
# this scipt is just a funny test, how such a can, might be filled during an
# analysis ...
# it is possible to execute this script
#
# the output can be read in, and will be displayed by
# canread.py
import sys
import pickle
import random
confirm_next_step = False

# this little can will hold 
# * all the settings, 
# * all results and intermediate results
# * as well as this script itself
# and then it will be written, to an output file
analysis = {}
can['input'] = {}       # 
can['settings'] = {}    # a subspace for holdind all settings
can['output'] = {}      # a subspace for holding all results... or similar stuff
can['logbook'] = []     # a list of statements ... human readable logbook
can['src'] = []         # this script and other sources

# store this scipt in the list of sources.
can['src'].append( open(sys.argv[0], 'r').read() )

# declare filenames to work with:
can['settings']['data_file_names'] = ['/media/daten_platte/FACT/data/20120229_144.fits.gz']
can['settings']['calib_file_names'] = ['/media/daten_platte/FACT/data/20120229_132.drs.fits.gz']
# we even tell the can, where we are going to store it
can['settings']['outfile_name'] = './can.pkl'  # <-- no list ... simple string


# put the settings for all the extractors and similar data processors 
# into the settings
can['settings']['SlidingAverage'] = [8]
can['settings']['DRSSpikes'] = []
can['settings']['GlobalMaxFinder'] = [40,200]
can['settings']['AmplitudeCleaner'] = [45,18,'return_bool_mask=False']

# prepare some space in the can, for the results of this script
can['results']['areas'] = []
can['results']['sizes'] = []
# and make some shortcuts
areas = can['results']['areas']
sizes = can['results']['sizes']

# this loop will loop over all events, out of all data files in the can,
# so the analysis loop doesn't even know, there are more files involved.
# of course in the logbook the opening and closing will be stored
for data in range(100):
    if True:

        size = 0
        for i in range(data):
            size += data
        
        area = random.randint(0,data)
        if area > 4:
            areas.append( area )
            sizes.append( size )
        # we suddenly realize, that we would like to store
        # the event IDs of events, which are have no survivors
        # we should scroll up ... before the loop and declare an empty list
        # like: can['results']['no_survivor_ids'] = []
        # but imagine we are writing a function, which is beeing called inside the loop
        # and this function has no possibility to declare that ...
        # well then this function can still put new things inside the can!
        else:
            if 'no_survivor_ids' not in can['results']:
                can['results']['no_survivor_ids'] = [data]
            else:
                can['results']['no_survivor_ids'].append(data)
        
        if confirm_next_step:
            user_input = raw_input("'q'-quit, 'r'-run, anything else goes one step")
            number=None
            try:
                number=int(user_input)
            except:
                number=None
            if user_input.find('q') != -1:
                sys.exit(0)
            elif user_input.find('r') != -1:
                confirm_next_step = False
            elif number!=None:
                run += number

# Now our analysis is done and we save the can
output = open(can['settings']['outfile_name'], 'wb')
pickle.dump(can, output)
output.close()