#!/usr/bin/python -tt
#
# Dominik Neise
#
import os.path
import numpy as np
import math
from euclid import *

class Coordinator(object):
    """ class to transform chid <-> hexagonal coordinates and vice versa """

    def __init__(self, map_file_path = "../map_dn.txt"):
        """ read map text file and generate from the three columns 
            chid, xe and ye
            3 dictionaries:  chid2coor, coor2chid, chid2nn  
            chid2nn means 'chid_to_next_neighbor_chids'
            
            this is done by calculating the hexagonal coordinates
            from the euclidian coordinates given in xe & ye.
            the center and the two base vectors are hard coded to be:
            center = Vector2( 0. , 1./2.)
            ey = Vector2( 0. , 1. )
            ex = Vector2( sqrt(3)/2. , 1./2. )
        """
        path = os.path.abspath(__file__)
        path = os.path.dirname(path)
        map_file_path = os.path.join(path, map_file_path)
        if not os.path.isfile(map_file_path):
            print 'not able to find file:', map_file_path
            sys.exit(-2)

        chid, y,x,xe,ye,yh,xh,softid,hardid = np.loadtxt(map_file_path, unpack=True)
        coors = zip(xe,ye,chid)
        vectors_and_chids = []
        for c in coors:
            vectors_and_chids.append( (Vector2(c[0], c[1]) , int(c[2])) )


        center = Vector2( 0. , 1./2.)
        ey = Vector2( 0. , 1. )
        ex = Vector2( math.sqrt(3)/2. , 1./2. )
        self.center = ( center.x , center.y )
        self.ey =  ( ey.x, ey.y)
        self.ex = ( ex.x, ex.y )

        coor2chid = {}
        chid2coor = {}
        chid2coor_np = {}
        chid2vec  = {}
        for vector_and_chid in vectors_and_chids:
            vec = vector_and_chid[0]
            chid = vector_and_chid[1]

            x = (vec-center).x / float(ex.x)
            y = ((vec-center)-x*ex).y / float(ey.y)
        
            if abs(x) < 0.01:
                x=0.0
            if abs(y) < 0.01:
                y=0.0

            
            coor = (int(round(x)),int(round(y)))
            coor_vec = Vector2(coor[0], coor[1])
            
            if coor in coor2chid:
                print 'error while filling "coor2chid":'
                print 'coor:',coor,'of chid:',chid,
                print 'is equal to coor of chid:',coor2chid[coor]

            coor2chid[ coor ] = chid
            chid2coor[ chid ] = coor
            chid2coor_np[ chid ] = np.array(coor)
            chid2vec[ chid ] = coor_vec

        # hard code the offsets to the next neighbors
        offsets = [ Vector2(1,0) , Vector2(-1,0) , Vector2(1,-1) , 
                    Vector2(0,1) , Vector2(0,-1) , Vector2(-1,1) ] 
        chid2nn = {}
        for chid in chid2coor.keys():
            coor = Vector2( chid2coor[chid][0] , chid2coor[chid][1] )
            nn_coors = []
            nn_chids = []
            for offset in offsets:
                nn_coors.append( ((coor+offset).x , (coor+offset).y) )
            for coor in nn_coors:
                if coor in coor2chid:
                    nn_chids.append( coor2chid[coor] )
            chid2nn[chid] = nn_chids
        self.nn = chid2nn
        self.chid2coor = chid2coor
        self.chid2coor_np = chid2coor_np
        self.coor2chid = coor2chid
        self.chid2vec  = chid2vec
        
#        for chid in chid2nn.keys():
#            print chid, '->',chid2nn[chid]

def first(a):
    return a[0]

def second(a):
    return a[1]

if __name__ == '__main__':
    co = Coordinator()
    
