#ifndef MARS_MFDataMember
#define MARS_MFDataMember

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFDataMember                                                                 //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MParList;
class TMethodCall;

class MFDataMember : public MFilter
{
private:
    TString        fDataMember; // Data member which should be used for the filter

    MParContainer *fObject;     // Object from which the value is retrieved
    TMethodCall   *fMethodCall; // Method call to the getter method of the requested value

    typedef enum { kELowerThan, kEGreaterThan } FilterType_t;
    FilterType_t fFilterType;

    Bool_t  fResult;
    Double_t fValue;

    void Init(const char type, const Int_t val,
              const char *name, const char *title);

public:
    MFDataMember(const char *member, const char type, const Double_t deg,
                 const char *name=NULL, const char *title=NULL);

    Bool_t IsExpressionTrue() const { return fResult; }
    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    void Print(Option_t *opt = "") const;

    ClassDef(MFDataMember, 0) // A Filter for cuts in any data member
};

#endif
