#!/usr/bin/python -tt
#
# Example
#    * looping over RawData class object
# 

from pyfact   import RawData
from plotters import Plotter
from drs_spikes import DRSSpikes


#define filenames
data_filename = 'data/20120223_210.fits.gz'
calib_filename = 'data/20120223_206.drs.fits.gz'

#make a RawData object
run = RawData(data_filename, calib_filename, return_dict = True)

#make a Plotter class ... this is an easy way for plotting ... but there are 
# many was to plot data ... without this class ... it was written for convenience, but there is no strong reason to use it...
myplotter = Plotter('titel of the plot', xlabel='time in slices', ylabel='amplitude calibrated data ... in mV')

# make a DRSSpike object ... this object is 
#DRS_spike_remover = DRSSpikes()


for event in run:
    print 'event id:', event['event_id']
    print 'trigger type', int(event['trigger_type'].value)
    data = event['acal_data']
    
    
    
    #if you like to have also the DRS spikes removed ... do:
    #data = DRS_spike_remover( data )
    
    myplotter( data[23] , 'pixel 23' )
    
    #if you like to skip the first 12slices and the last 12slices this can be done like this
    #myplotter( data[23, 12:-12] , 'pixel 23 skiped first 12 and last 12 slices :-)' )

    answer = raw_input('hit <Enter> to go on .... hit "q" to quit')
    if 'q' in answer:
        break
