#!/usr/bin/python -tt
#
# Werner Lustermann
# ETH Zurich
#
from ROOT import TFile
import numpy as np
from pyfact import RawData
from plotter import Plotter
from drs_spikes import DRSSpikes

from hist import hist, histogramList, SaveHistograms

import matplotlib.pyplot as plt

spike_histo = {}
spike_histo['cand'] = hist('N_candidates', 'N candidates',  
                10000, 0., 10000., 'number of spike candidates', 'N / 1')
spike_histo['sing']= hist('N_singles', 'N singles', 
                10000, 0., 10000., 'number of signel spikes', 'N / 1')
spike_histo['doub'] = hist('N_doubles', 'N doubles', 
                10000, 0., 10000., 'number of double spikes', 'N / 1')


spike_histo['all_ampl'] = hist('all_ampl', 'indicator all amplitude',                 1000, -1000., 1000., 'indicator amplitude in mV', 'N / 2 mV')
spike_histo['cand_ampl'] = hist('cand_ampl', 'candidate amplitudes',                 500, 0., 1000., 'indicator amplitude in mV', 'N / 2 mV')
spike_histo['sing_ampl'] = hist('cand_ampl_single', 'amplitude singles',                500, 0., 1000., 'indicator amplitude in mV', 'N / 2 mV')
spike_histo['doub_ampl'] = hist('cand_ampl_double', 'amplitude doubles',                 500, 0., 1000., 'indicator amplitude in mV', 'N / 2 mV')

spikes = {}
spikes['cand'] = []
spikes['sing'] = []
spikes['doub'] = []
spikes['cand_ampl'] = []
spikes['sing_ampl'] = []
spikes['doub_ampl'] = []
#spikes['ind'] = []

def spike_ana(candidates, singles, doubles, data, ind):
    """ call back function for DRSSpikes class """

    #number of spikes
    #print len(candidates), len(singles), len(doubles)
    spikes['cand'].append(len(candidates))
    spikes['sing'].append(len(singles))
    spikes['doub'].append(len(doubles))
    spike_histo['cand'](len(candidates))
    spike_histo['sing'](len(singles))
    spike_histo['doub'](len(doubles))

    spike_histo['all_ampl'](ind)
    spike_histo['cand_ampl'](ind[ np.array(candidates)+1])
    spike_histo['sing_ampl'](ind[ np.array(singles)+1])
    spike_histo['doub_ampl']( (ind[ np.array(doubles)+1] + ind[ np.array(doubles)+2]) / 2.)

    spikes['cand_ampl'].extend( list(ind[ np.array(candidates)+1]) )
    spikes['sing_ampl'].extend( list(ind[ np.array(singles)+1]) )
    spikes['doub_ampl'].extend( list(
            (ind[ np.array(doubles)+1] + ind[ np.array(doubles)+2]) / 2.) )
    print 'len() ', len( spikes['sing_ampl'] )
    #print spikes['sing_ampl']

    #spike_histo('ind_ampl_single', ind[single]
    #amplitudes
    #print 'ampl'
    #row, col = data.shape
    # print 'row, col: ', row, col
    #a,b = divmod(singles[0], col)
    #print singles[0], a, b, data[a,b-1], data[a,b], data[1,b+1]

data_file_name = '/home/luster/win7/FACT/data/raw/20111124/20111124_117.fits.gz'
calib_file_name = '/home/luster/win7/FACT/data/raw/20111124/20111124_114.drs.fits.gz'
run = RawData( data_file_name, calib_file_name )

remove_spikes = DRSSpikes(5., user_action=spike_ana, debug=False)

#for event in range(1000):
ev = 0
for data, scell, tt in run:
    print 'event ', ev
    ev += 1
    if ev == 100:
        break
    remove_spikes(data)
    

root_file = TFile( 'spike_histo.root', 'RECREATE')
    
root_file.mkdir( 'spike_histo' )
root_file.cd( 'spike_histo' )
for key in spike_histo:
    spike_histo[key].mkroot()
    spike_histo[key].rh.Write()

root_file.Close()

plt.figure()
plt.semilogy(spike_histo['all_ampl'].y, 'b', label = 'all')
plt.semilogy(spike_histo['cand_ampl'].y, 'r', label='candidates')
plt.title('Estimator values')
plt.xlabel('estimator value')
plt.ylabel('N / 1')
plt.legend()
plt.savefig('spike_histo.jpg')

x = range(len(spikes['cand']))

plt.figure()
plt.plot(x, np.array(spikes['cand']), 'b.', label='candidates')
plt.plot(x, np.array(spikes['sing']), 'g.', label='singles')
plt.plot(x, np.array(spikes['doub']), 'r.', label='doubles')
plt.savefig('t.jpg')

plt.title('Number of spikes')
plt.grid(True)
plt.legend()
plt.xlabel('event')
plt.ylabel('N spikes')
plt.savefig('n_spikes.jpg')

plt.figure()
plt.hist(np.array(spikes['cand']), 100, color='blue', 
         label='candidates', histtype='step')
plt.hist(np.array(spikes['sing']), 100, color='green',
         label='singles', histtype='step')
plt.hist(np.array(spikes['doub']), 100, color='red',
         label='doubles', histtype='step')
plt.grid(True)
plt.title('Number of spike candidates')
plt.legend()
plt.savefig('spikes_hist.jpg')

plt.figure()
plt.hist(np.array(spikes['cand_ampl']), 100, color='blue',
         label='candidates', histtype='step', log=True)
plt.hist(np.array(spikes['sing_ampl']), 100, color='green',
         label='singles', histtype='step', log=True)
plt.hist(np.array(spikes['doub_ampl']), 100, color='red',
         label='doubles', histtype='step', log=True)
plt.grid(True)
plt.title('Amplitude of spikes spike indicator')
plt.legend()
plt.savefig('spikes_ampl_hist.jpg')

plt.show()
